/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.Data;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;

/**   
 * @title       : QRCodeSceneStr 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月28日 下午2:18:00 
 */
@Data
public class QRCodeSceneStr{
	
	private static final String SEPARATOR = "_";
	private static final String EQUAL = "=";
	
	
	private static final String JSON_KEY_QRCODE_TYPE = "qr";
	
	protected QRCodeType qrCodeType;
	
	@SuppressWarnings("unused")
	private void setQrCodeType(QRCodeType qrCodeType){}
	
	public String getSceneStr(){
		return createSceneStrParam(JSON_KEY_QRCODE_TYPE, qrCodeType.getValue());
	}
	
	
	public static QRCodeType parseQRCodeType(String str){
		return QRCodeType.getByVaule(parseSceneStrParam(str, JSON_KEY_QRCODE_TYPE));
	}
	
	protected static String createSceneStrParam(String key,Object value){
		return String.format("%s%s%s%s", key, EQUAL, value, SEPARATOR);
	}
	
	protected static String parseSceneStrParam(String str, String key){
		if(!str.startsWith(SEPARATOR)){
			str = SEPARATOR+str;
		}
		String pattenStr = String.format("%s%s%s([^%s]*)", SEPARATOR, key, EQUAL, SEPARATOR);
		Pattern pattern = Pattern.compile(pattenStr);
		Matcher matcher = pattern.matcher(str);
		if (matcher.find()) {
			return matcher.group(1);
		} 
		return null;
	}
	
//	public static void main(String args[]){
//		String str = "qr=activity_aid=7_at=99_";
//		String key = "qr";
//		
//		String pattenStr = String.format("%s%s%s([^%s]*)", SEPARATOR, key, EQUAL, SEPARATOR);
//		Pattern pattern = Pattern.compile(pattenStr);
//		Matcher matcher = pattern.matcher(str);
////		if (matcher.find()) {
////			return matcher.group(1);
////		} 
//		
//		System.out.println( parseQRCodeType(str) );
//	}
}

