
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.dto.menu;

import java.util.Arrays;
import java.util.List;

import com.baijia.tianxiao.util.GenericsUtils;
import com.beust.jcommander.internal.Lists;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 22, 2016
 * @Desc 复合菜单
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ComplexButton extends Button {

    private List<Button> sub_button;

    public void addSubButton(Button...subButtons) {
        if (GenericsUtils.notNullAndEmpty(subButtons)) {
            if (sub_button == null) {
                this.sub_button = Lists.newArrayList();
            }
            sub_button.addAll(Arrays.asList(subButtons));
        }
    }

    public static void main(String[] args) {
        ComplexButton cb = new ComplexButton();
        // 网校主页菜单按钮
        ViewButton weiXiaoZhuYe = new ViewButton("网校主页");
        weiXiaoZhuYe.setUrl("");
        ViewButton xiaoqQuDiZhi = new ViewButton("校区地址");
        xiaoqQuDiZhi.setUrl("");
        ViewButton _400Mobiles = new ViewButton("400电话");
        _400Mobiles.setUrl("");
        cb.addSubButton(weiXiaoZhuYe, xiaoqQuDiZhi, _400Mobiles);
        System.out.println(cb.getSub_button().size());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */

    @Override
    public String toString() {
        return "ComplexButton [sub_button=" + sub_button + ", name=" + name + "]";
    }

}
