/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;

/**
 * @author : zhenyujian
 * @title : AuthorizerInfoService
 * @description : 公众号授权 - 授权账户基本信息
 * @date : 2015年12月12日 下午8:41:28
 */
public interface AuthorizerInfoService {

    /**
     * @Description  : 更新 AuthorizerInfo (授权账户基本信息)
     * @Author       : zhenyujian
     */
    void update(AuthorizerInfo authorizerInfo);

    
    /**
     * @Description  : 查询 AuthorizerInfo (授权账户基本信息)
     * @Author       : zhenyujian
     */
    AuthorizerInfo getByOrgId(Integer orgId);

    
    /**
     * @Description  : 查询 AuthorizerInfo (授权账户基本信息)
     * @Author       : zhenyujian
     */
    AuthorizerInfo getByUserName(String userName);

    
    /**
     * @Description  : 查询 AuthorizerInfo (授权账户基本信息)
     * @Author       : zhenyujian
     */
    AuthorizerInfo getByAuthorizerAppId(String authorizerAppId);

    
    /**
     * @Description  : 从微信同步公众号的基本信息
     * @Author       : zhenyujian
     */
    AuthorizerInfo syncAuthorizerInfo(Integer orgId, String authorizerAppId);
    

    /**
     * 重启的时候调用,重置进行中的任务   
     * AuthorizerInfo表存在 微信粉丝、素材同步标志位 重启服务器任务中断需重置处于进行中的任务标志位
     */
    void resetOngoing();
    
}
