/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;

public class StorageUtil {

    /**
     * 构造主站图片url(参数对应cdb.storage表字段)
     * 
     * @param fid
     * @param mimeType
     * @param sn
     * @return
     */
    // public static String constructUrl(Long fid, String mimeType, String sn) {
    // String img_server = TianxiaoProperties.getProperty("img.server");
    // StringBuilder sb = new StringBuilder(img_server);
    // String surfix = "";
    // if (StringUtils.isNotBlank(mimeType)) {
    // if (mimeType.contains("/")) {
    // surfix = mimeType.split("/")[1];
    // } else {
    // surfix = mimeType;
    // }
    // }
    // return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    // }

    /**
     * 构造机构系统图片url(参数对应yunying.org_storage表字段)
     * 
     * @param fid
     * @param sn
     * @param mineType
     * @return
     */
    public static String constructUrl(String fid, String sn, Integer mineType) {
        MIMEType mimeType = MIMEType.getMimeType(mineType);
        String fileServer = null;

        if (mimeType == null || mimeType.equals(MIMEType.MP3.getCode()) || mimeType.equals(MIMEType.AMR.getCode())) {
            fileServer = WechatProperties.getFileServer();
        } else {
            fileServer = WechatProperties.getImageServer();
        }

        StringBuilder sb = new StringBuilder(fileServer);
        String surfix = ((MIMEType.values())[mineType - 1]).getExtension();
        return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    }
    
    public static String constructUrl(OrgStorage orgStorage){
    	return constructUrl(orgStorage.getFid(),orgStorage.getSn(),orgStorage.getMimeType());
    }

}
