package com.baijia.tianxiao.sal.wechat.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;

/**
 * 
 * @title FileUtil
 * @desc TODO
 * @author wangzhigang
 * @date 2014年10月17日
 * @version 1.0
 */
public class FileUtil {


    public static boolean mkdir(String f) throws Exception {
        try {
            java.io.File file = new java.io.File(f);
            file.mkdir();
            return true;
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 删除文件
     * 
     * @param f
     * @return
     */
    public static boolean delete(String f) throws Exception {
        try {
            java.io.File file = new java.io.File(f);
            file.delete();
            return true;
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 读取文本文件内容, 平台默认编码
     * 
     * @param file
     * @return
     * @throws Exception
     */
    public static String read(String file) throws Exception {
        return read(file, null);
    }

    /**
     * 
     * @param in
     * @return
     * @throws Exception
     */
    public static String read(InputStream in) throws Exception {
        return read(in, System.getProperty("file.encoding"));
    }

    /**
     * 
     * @param in
     * @param encoding
     * @return
     * @throws Exception
     */
    public static String read(InputStream in, String encoding) throws Exception {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(in, encoding));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (br != null) {
                    br.close();
                }
            } catch (IOException e) {
                throw e;
            }
        }
    }

    /**
     * 读取文本文件内容, 指定字符编码
     * 
     * @param file
     * @param encoding
     * @return
     * @throws Exception
     */
    public static String read(String file, String encoding) throws Exception {
        BufferedInputStream result = null;
        try {
            result = new BufferedInputStream(new FileInputStream(file));
            byte[] cont = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int conlen;
            while ((conlen = result.read(cont)) >= 0) {
                baos.write(cont, 0, conlen);
            }
            if (encoding != null) {
                return new String(baos.toByteArray(), encoding);
            } else {
                return new String(baos.toByteArray());
            }
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                result.close();
            } catch (Exception e) {
                throw e;
            }
        }
    }

    /**
     * 写文件, 添加到原有内容末尾
     * 
     * @param f
     * @param s
     * @param append
     * @return
     */
    public static boolean write(String f, String s, boolean append) throws Exception {
        return write(f, s.getBytes(), append);
    }

    /**
     * 写文件, 覆盖原有内容
     * 
     * @param f
     * @param s
     * @param append
     * @return
     */
    public static boolean write(String f, String s) throws Exception {
        return write(f, s.getBytes(), false);
    }

    /**
     * 写文件, 覆盖原有内容
     * 
     * @param f
     * @param b
     * @param append
     * @return
     */
    public static boolean write(String f, byte[] b) throws Exception {
        return write(f, b, false);
    }

    /**
     * 写文件
     * 
     * @param f
     * @param b
     * @param append
     * @return
     * @throws Exception
     */
    public static boolean write(String f, byte[] b, boolean append) throws Exception {
        FileOutputStream fos = null;
        try {
            File file = new File(getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new FileOutputStream(f, append);
            fos.write(b);
            return true;
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            } catch (Exception e) {
                throw e;
            }
        }
    }

    /**
     * 读取二进制文件内容
     * 
     * @param file
     * @return
     */
    public static Object readObject(String file) throws Exception {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(file));
            Object obj = ois.readObject();
            return obj;
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                ois.close();
            } catch (Exception e) {
                throw e;
            }
        }
    }

    /**
     * 写二进制文件内容
     * 
     * @param f
     * @param o
     * @return
     */
    public static boolean writeObject(String f, Object o) throws Exception {
        ObjectOutputStream oos = null;
        try {
            File file = new File(getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(o);
            return true;
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                oos.close();
            } catch (Exception e) {
                throw e;
            }
        }
    }

    public static boolean writeGZIPFile(String f, String s) throws Exception {
        return writeGZIPFile(f, s.getBytes());
    }

    /**
     * 写压缩文件
     * 
     * @param f
     * @param b
     * @return
     * @throws Exception
     */
    public static boolean writeGZIPFile(String f, byte[] b) throws Exception {
        GZIPOutputStream fos = null;
        try {
            File file = new File(getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new GZIPOutputStream(new FileOutputStream(f));
            fos.write(b);
            return true;
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            } catch (Exception e) {
                throw e;
            }
        }
    }

    public static String getExtension(String file) {
        String extName = "";
        int idx = file.lastIndexOf(".");
        if (idx > 0) {
            extName = new String(file.substring(idx + 1));
        }
        return extName.trim();
    }

    public static String getFormatedExtension(String file) {
        return getExtension(file).toLowerCase();
    }

    private static String getPath(String f) {
        return f.substring(0, f.lastIndexOf(File.separator));
    }
}
