/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.dto.upload.UploadResult.UploadFile;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatOpenIdRecordService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.FreeVersionMenuClick;
import com.baijia.tianxiao.sal.wechat.constant.emoticons.WechatEmoticons;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgType;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.org.OrgCenterInfo;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStr;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrActivity;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrSubscribeOrg;
import com.baijia.tianxiao.sal.wechat.dto.request.MessageRequest;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSCANEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatImageMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatVoiceMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.AutoReplyHelper;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.KeyWordMatcher;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgHelper;
import com.baijia.tianxiao.sal.wechat.helper.common.MessageBuilder;
import com.baijia.tianxiao.sal.wechat.helper.common.WechatCryptUtils;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.AudioUtil;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * @title : MessageReceiveServiceImpl
 * @description : 接收来自微信的消息并推送给app端
 * @author : zhenyujian
 * @date : 2015年12月14日 下午1:49:54
 */
@Slf4j
@Service
public class MessageReceiveServiceImpl implements MessageReceiveService, InitializingBean {

    private static final String RELEASE_TEST_USERNAME = "gh_3c884a361561"; // 全网检测专用公众号用户名

    @Autowired
    private ReleaseTest releaseTest;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgWechatReplyForKeywordDao replyForKeywordDao;
    @Autowired
    private OrgWechatReplyForSubscribeDao replySubscribeDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;
    @Autowired
    private WechatOpenIdRecordService wechatOpenIdRecordService;

    @Autowired(required = false)
    private CloudAccount cloudAccount;
    private CloudQueue consultMsgQueue;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String generateDefaultResponse() {
        return "";
    }

    /**
     * @Description : 接收微信消息
     * @Author : zhenyujian
     * @Date : 2015年12月14日 下午4:51:43
     *
     * @Return : boolean
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String handle(MessageRequest request) {
        log.info("handle - message from wechat to app - request:{}", request);

        try {

            // 消息解密得到xml文本
            String xmlMsg = WechatCryptUtils.decryptMsg(request.getMsgSignature(), request.getTimestamp(),
                request.getNonce(), request.getPostData());

            // xml解析
            WechatAbstractMessage message = MessageBuilder.build(xmlMsg);
            log.info(" message is : {} ", message);
            // NOTE: 此处进入全网检测流程
            if (message.getToUserName().equals(RELEASE_TEST_USERNAME)) {
                return releaseTest.handleTestMsg(message);
            }
            log.info("=======0======");

            // 根据消息类型 完成相应操作 并作出相应响应
            if (message.getMsgType() == WechatMsgType.EVENT) {
                // 1.事件消息
                WechatEventMessage eventMessage = (WechatEventMessage) message;

                // 微信消息重试机制过滤
                String msgKey =
                    String.format("wechat.msg.%s.%s", eventMessage.getFromUserName(), eventMessage.getCreateTime());
                if (!isFirstTimeHandle(msgKey)) {
                    return generateDefaultResponse();
                }

                // 粉丝信息处理
                fansPretreatment(eventMessage);

                // 消息响应处理
                return generateEventResponse(eventMessage);

            } else {
                // 2.普通消息
                try {
                    log.info("普通消息------");
                    WechatOrdinaryMessage ordinaryMessage = (WechatOrdinaryMessage) message;

                    // 微信消息重试机制过滤
                    String msgKey = String.format("wechat.msg.%s", ordinaryMessage.getMsgId());
                    if (!isFirstTimeHandle(msgKey)) {
                        return generateDefaultResponse();
                    }

                    // 粉丝信息处理
                    fansPretreatment(ordinaryMessage);

                    // 消息响应处理
                    String result = generateOrdinaryResponse(ordinaryMessage);
                    log.info("result:{}", result);
                    return result;

                } catch (Exception e) {
                    log.error("handle - generateOrdinaryResponse - exception", e);
                    return generateDefaultResponse();
                }
            }
        } catch (WechatException e) {
            log.warn("MessageReceiveServiceImpl - handle - WechatException", e);
            return generateDefaultResponse();
        }catch (Exception e) {
            log.error("MessageReceiveServiceImpl - handle - exception", e);
            return generateDefaultResponse();
        }
    }

    /**
     * @Description : 事件消息处理
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午9:30:07
     *
     * @Return : String
     */
    private String generateEventResponse(WechatEventMessage message) {

        switch (message.getEvent()) {

            // 用户关注事件
            case SUBSCRIBE: {
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage) message;
                AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(subscribeMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return generateDefaultResponse();
                }

                if (StringUtils.isNotBlank(subscribeMsg.getTicket())) {
                    // http://mp.weixin.qq.com/wiki/7/9f89d962eba4c5924ed95b513ba69d9b.html#.E6.89.AB.E6.8F.8F.E5.B8.A6.E5.8F.82.E6.95.B0.E4.BA.8C.E7.BB.B4.E7.A0.81.E4.BA.8B.E4.BB.B6
                    String params = subscribeMsg.getEventKey();

                    QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                    
                    if (qwCodeType != null){
                        switch (qwCodeType) {
                            case CUSTOM_ACTIVITY: {
                                QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                                OrgWechatCustomActivity customActivity = customActivityDao.get(dto.getActivityId(), dto.getActivityType());
                                Template template = templateDao.selectTemplateById(dto.getActivityType());
                                String relativePath = (template != null ? template.getUrl() : null);
                                String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE,
                                															authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(),
                                															customActivity.getActivityType(), relativePath);
                                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(),
                                									  message.getFromUserName(), customActivity.getTitle(),
                                									  customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                            }

                            case SUBCRIBE_WITH_ORG_ID: {
                                QRCodeSceneStrSubscribeOrg dto1 = QRCodeSceneStrSubscribeOrg.fromSceneStr(params);
                                String freeVersionCheck = orgIdQrCodeReply4FreeVersion(authorizerInfo, message, dto1.getOrgId());

                                if (freeVersionCheck != null) {
                                    return freeVersionCheck;
                                }
                            }
                        }
                    }else {
                        log.warn("wechat QRCodeType is null - params:{}", params);
                    }

                }

                // 发送 关注回复消息
                OrgWechatReplyForSubscribe reply = replySubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
                String replyContent = PassiveReplyMsgHelper.getSubscribeReply(subscribeMsg.getToUserName(),
                															  subscribeMsg.getFromUserName(), reply);
                
                if (reply != null && !replyContent.equals("success")) {
                    AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                    try {
                        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                        // 发送消息
                        AutoReplyHelper.sendSubscribeReply(authorizationInfo.getAuthorizerAccessToken(), subscribeMsg.getFromUserName(), reply);
                    } catch (Exception e) {
                        return replyContent;
                    }
                } else {
                    // 默认关注自动回复
                    return getDefaultSubscribeReply(subscribeMsg, authorizerInfo);
                }
                break;
            }

            // 用户取消关注事件
            case UNSUBSCRIBE: {
                break;
            }

            // 二维码扫描
            case SCAN: {
                WechatSCANEventMessage scanMsg = (WechatSCANEventMessage) message;
                AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(scanMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return generateDefaultResponse();
                }

                if (StringUtils.isNotBlank(scanMsg.getTicket())) {
                    // http://mp.weixin.qq.com/wiki/7/9f89d962eba4c5924ed95b513ba69d9b.html#.E6.89.AB.E6.8F.8F.E5.B8.A6.E5.8F.82.E6.95.B0.E4.BA.8C.E7.BB.B4.E7.A0.81.E4.BA.8B.E4.BB.B6
                    String params = scanMsg.getEventKey();

                    QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);

                    if (qwCodeType != null) {
                        switch (qwCodeType) {
                            case CUSTOM_ACTIVITY: {
                                QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                                OrgWechatCustomActivity customActivity = customActivityDao.get(dto.getActivityId(), dto.getActivityType());
                                Template template = templateDao.selectTemplateById(dto.getActivityType());
                                String relativePath = (template != null ? template.getUrl() : null);
                                String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE,
                                															authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(),
                                															customActivity.getActivityType(), relativePath);
                                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(),
                                									  message.getFromUserName(), customActivity.getTitle(),
                                									  customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                            }

                            case SUBCRIBE_WITH_ORG_ID: {
                                QRCodeSceneStrSubscribeOrg dto1 = QRCodeSceneStrSubscribeOrg.fromSceneStr(params);
                                String freeVersionCheck = orgIdQrCodeReply4FreeVersion(authorizerInfo, message, dto1.getOrgId());

                                if (freeVersionCheck != null) {
                                    return freeVersionCheck;
                                }
                            }
                        }
                    } else {
                        log.warn("wechat - unknow qwCodeType - params:{}", params);
                    }
                }
                break;
            }

            // 上报地理位置事件
            case LOCATION: {
                break;
            }

            // 点击菜单拉取消息时的事件推送
            case MENU_CLICK: {
                AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());
                sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());

                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return generateDefaultResponse();
                }

                // 免费版
                String freeVersionCheck = menuClick4FreeVersion(authorizerInfo, message);
                if (freeVersionCheck != null) {
                    return freeVersionCheck;
                }

                // 普通版
                OrgWechatCustomMenu menu =
                    orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());

                if (menu != null) {
                    Map<String, String> keyVsContentMap = WechatMenuJsonConverter.mapClickKeyVsContent(menu.getJson());
                    if (keyVsContentMap != null && !keyVsContentMap.isEmpty()) {
                        String content = keyVsContentMap.get(message.getEventKey());
                        if (StringUtils.isNotBlank(content)) {
                            // 发送 点击事件回复
                            AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                            if (authorizationInfo != null) {
                                CustomerServiceApiCaller.sendTextMsg(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), content);
                            }
                        }
                    }
                }

                break;
            }

            // 点击菜单跳转链接时的事件推送
            case MENU_VIEW: {
                AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());
                sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                break;
            }

            case UNKNOWN: {
                log.warn("wechat - receive unknown event message - message:{}", message);
                break;
            }
        }

        return generateDefaultResponse();
    }

    String getDefaultSubscribeReply(WechatSubscribeEventMessage message, AuthorizerInfo authorizerInfo) {
        // 免费版
        if (freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            StringBuilder content = new StringBuilder();
            content.append("欢迎关注" + authorizerInfo.getNickName() + "！\n");
            content.append("添加机构后，你可以在线联系机构，在个人中心查看自己的课程及签到情况等信息哦！\n");
            content.append("如何添加机构？\n");
            content.append("扫描机构的二维码，或者直接在对话框中输入机构的天校号就可以了！");
            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
        }

        // 普通版
        Integer orgId = authorizerInfo.getOrgId();
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);

        OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        StringBuilder content = new StringBuilder();
        content.append("致亲爱的你：\n\n");
        content.append("欢迎加入").append(orgInfo.getShortName()).append("大家庭!").append("\n\n");
        content.append(getHrefLink(MediaType.WANGXIAOZHUYE.getUrl(owDto), orgInfo.getShortName() + "微官网正式上线啦!进来看看有惊喜哦!")).append("\n\n");
        content.append("现在预约体验课，获豪华大礼包（仅限首次预约用户），还在等什么，点击")
               .append(getHrefLink(MediaType.YUYUESHITING.getUrl(owDto), "预约试听")).append("!").append("\n\n");
        content.append("咨询课程？欢迎留下您的姓名、联系方式，我们会有专业的老师帮您详细解答。").append("\n\n");

        if (authorizerInfo.hasWebAuthPermission()) {// 公众号具备网页授权权限
             content.append("想快速查课表、写评价、看上课记录？不论是学生还是老师，可在“")
                	.append(getHrefLink(MediaType.XUESHENGZHONGXIN.getUrl(owDto), "学生中心")).append("/")
                	.append(getHrefLink(MediaType.LAOSHIZHONGXIN.getUrl(owDto), "老师中心")).append("”轻松完成，马上进行身份验证吧。")
                	.append("\n\n");
        }

        TX400Phone tx400Phone = tx400PhoneDao.getByOrgId(orgId);
        if(tx400Phone!=null && !Flag.getBoolean(tx400Phone.getIsdel())){//自有400
            content.append("有话对我们说？欢迎打电话给我们哟~ ").append(tx400Phone.getPhone400()).append(" ，我们将悉心聆听，竭诚为您服务。").append("\n\n");
        } else {
            content.append("有话对我们说？欢迎打电话给我们哟~ ")
                   .append(WechatProperties.getMobileNumber400Main() + "转" + orgInfo.getExtension())
                   .append(" ，我们将悉心聆听，竭诚为您服务。").append("\n\n");
        }
        content.append("精彩活动，敬请关注！").append("\n\n");

        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
    }

    String getHrefLink(String href, String content) {
        String link = "<a href=\"%s\">%s</a>";
        return String.format(link, href, content);
    }

    void sendMenuVisitMonitor(AuthorizerInfo authorizerInfo, String openId) {
        if (authorizerInfo == null || StringUtils.isBlank(openId)) {
            return;
        }
        try {
            OrgAccount orgAccount = orgAccountDao.getAccountById(authorizerInfo.getOrgId());
            String url = WechatProperties.getWebCRMUrlPrefix() + "monitor.do";
            Map<String, String> params = new HashMap<String, String>();
            params.put("orgNumber", orgAccount.getNumber() + "");
            params.put("userNumber", openId);
            params.put("typeNumber", 10 + "");// type = 10
            // http://git.baijiahulian.com/yunying/tianxiao/wikis/App_crm_monitor
            HttpClientUtils.doGet(url, params);
        } catch (Exception e) {
        }
    }

    /**
     * @throws Exception
     * @throws WebServiceException
     * @throws WechatException
     * @Description : 普通消息处理
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午11:16:12
     *
     * @Return : String
     */
    private String generateOrdinaryResponse(WechatOrdinaryMessage message)
        throws WechatException, WebServiceException, Exception {

        switch (message.getMsgType()) {
            // 文本消息
            case TEXT: {
                return generateTextOrdinaryResponse((WechatTextMessage) message);
            }

            // 图片消息消息
            case IMAGE: {
                return generateImageOrdinaryResponse((WechatImageMessage) message);
            }

            // 语音消息
            case VOICE: {
                return generateVoiceOrdinaryResponse((WechatVoiceMessage) message);
            }

            // 视频消息
            case VIDEO: {
                break;
            }

            // 小视频消息
            case SHORT_VIDEO: {
                break;
            }

            // 位置消息
            case LOCATION: {
                break;
            }

            // 链接消息
            case LINK: {
                break;
            }

            case UNKNOWN: {
                log.warn("wechat - receive unknown type message - message:{}", message);
                break;
            }

            default: {

            }
        }

        return generateDefaultResponse();
    }

    /**
     * @Description : 普通消息 - 文本
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午11:15:45
     *
     * @Return : String
     */
    private String generateTextOrdinaryResponse(WechatTextMessage message) {

        log.info("普通消息-文本 {} ", message);

        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());
        if (authorizerInfo == null) { // || !authorizerInfo.isPassedVerify()
            return generateDefaultResponse();
        }

        Fans fans = fansDao.getByOpenId(message.getFromUserName());

        // 免费版
        String freeVersionCheck = txNumerReply4FreeVersion(authorizerInfo, message);
        if (freeVersionCheck != null) {
            return freeVersionCheck;
        }

        // 1. 推送 - 消息给app
        if (fans != null) {
            // 拼装消息
            MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.date2UnixTimestamp(message.getCreateTime()),
                    						authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(),
                    						fans.getShowName(), fans.getHeadImgUrl());

            dto.setTextContent(WechatEmoticons.convert(message.getContent()));

            // 调用推送接口 (推送消息给app)
            String msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJsonStr());
            try {
                consultMsgQueue.putMessage(new Message(msg));
                log.info("put message to consultMsgQueue msg:{}", msg);
            } catch (Exception e) {
                log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", msg, e);
            }
        }

        // 2. 回复 - 关键词回复消息
        String keywordReply = getKeywordReply(message, authorizerInfo);
        if (keywordReply != null) {
            return keywordReply;
        }

        return generateDefaultResponse();
    }

    // 查询 关键词回复
    String getKeywordReply(WechatTextMessage message, AuthorizerInfo authorizerInfo) {
        List<OrgWechatReplyForKeyword> replyList = replyForKeywordDao.search(authorizerInfo.getAuthorizerAppId(), null);
        OrgWechatReplyForKeyword reply = KeyWordMatcher.match(message.getContent(), replyList);

        if (reply != null) {
            AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            try {
                WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                // 发送消息
                AutoReplyHelper.sendKeywordReply(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), reply);
            } catch (Exception e) {
                return PassiveReplyMsgHelper.getKeywordReply(message.getToUserName(), message.getFromUserName(), reply);
            }
        }
        return null;
    }

    /**
     * @throws Exception
     * @throws WebServiceException
     * @throws WechatException
     * @Description : 普通消息 - 图片
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午11:48:28
     *
     * @Return : String
     */
    private String generateImageOrdinaryResponse(WechatImageMessage message)
        throws WechatException, WebServiceException, Exception {

        Fans fans = fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            return generateDefaultResponse();
        }

        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());

        // 免费版 检测
        if (freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            return generateDefaultResponse();
        }

        AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        if (authorizationInfo == null) {
            return generateDefaultResponse();
        }

        // 下载、上传文件
        Long uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        File localFile = null;
        Integer storageId;
        OrgStorage orgStorage;
        int imageWidth;
        int imageHeight;
        try {
            byte[] data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            UploadResult result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = saveToDb(result, MIMEType.JPG);
            orgStorage = orgStorageDao.getById(storageId);

            // 获取图片宽、高
            BufferedImage image = ImageIO.read(localFile);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();

        } catch (Exception e) {
            log.error("wechat - generateImageOrdinaryResponse - exception", e);
            return generateDefaultResponse();
        } finally {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }

        // 拼装消息
        MessageDto dto = new MessageDto(MsgType.PICTURE.getValue(),
        								DateUtil.date2UnixTimestamp(message.getCreateTime()), authorizerInfo.getOrgId(),
        								authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setImageContent(storageId, StorageUtil.constructUrl(orgStorage), imageHeight, imageWidth);

        // 调用推送接口
        String msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            consultMsgQueue.putMessage(new Message(msg));
            log.info("put message to consultMsgQueue msg:{}", msg);
        } catch (Exception e) {
            log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", msg, e);
        }

        return generateDefaultResponse();
    }

    /**
     * @throws Exception
     * @throws WebServiceException
     * @throws WechatException
     * @Description : 普通消息 - 语音
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午11:48:33
     *
     * @Return : String
     */
    private String generateVoiceOrdinaryResponse(WechatVoiceMessage message)
        throws WechatException, WebServiceException, Exception {

        Fans fans = fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            return generateDefaultResponse();
        }

        // 开启了语音识别
        if (StringUtils.isNotBlank(message.getRecognition())) {
            WechatTextMessage textMessage = new WechatTextMessage("[语音识别] " + message.getRecognition());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return generateTextOrdinaryResponse(textMessage);
        }
        // 格式判断
        if (!message.getFormat().toLowerCase().equals("amr")) {
            WechatTextMessage textMessage = new WechatTextMessage("[不支持的语音类型] " + message.getFormat().toLowerCase());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return generateTextOrdinaryResponse(textMessage);
        }
        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());

        // 免费版 检测
        if (freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            return generateDefaultResponse();
        }

        AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());

        // 上传、下载文件
        Long uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        File localFile = null;
        Integer storageId;
        OrgStorage orgStorage;
        Integer voiceLength;
        try {
            byte[] data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.AMR);
            UploadResult result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = saveToDb(result, MIMEType.AMR);
            orgStorage = orgStorageDao.getById(storageId);

            // 获取音频文件时长
            voiceLength = Integer.parseInt(AudioUtil.getAmrDuration(localFile) + "");

        } catch (Exception e) {
            log.error("wechat - generateVoiceOrdinaryResponse - exception", e);
            return generateDefaultResponse();
        } finally {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }

        // 拼装消息
        MessageDto dto = new MessageDto(MsgType.VOICE.getValue(), DateUtil.date2UnixTimestamp(message.getCreateTime()),
        								authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(),
        								fans.getShowName(), fans.getHeadImgUrl());
        dto.setVoiceContent(storageId, StorageUtil.constructUrl(orgStorage), voiceLength);

        // 调用推送接口
        String msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            consultMsgQueue.putMessage(new Message(msg));
            log.info("put message to consultMsgQueue msg:{}", msg);
        } catch (Exception e) {
            log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", msg, e);
        }

        return generateDefaultResponse();
    }

    /**
     * @Description : 事件消息 - 关注
     * @Author : zhenyujian
     * @Date : 2015年12月4日 下午11:43:24
     *
     * @Return : String
     */
    @SuppressWarnings("unused")
    private String generateSubscribeEventResponse(WechatSubscribeEventMessage message) {
        try {
            AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(authorizerInfo.getOrgId());
            OrgTxtMsg brief = orgTxtMsgDao.getOrgTxtByIdAndType(authorizerInfo.getOrgId(), 3101); // 机构一句话简介

            StringBuilder msg = new StringBuilder();
            String intro = "";
            if (brief != null && StringUtils.isNotBlank(brief.getValue())) {
                intro = brief.getValue();
            }
            msg.append("感谢关注【").append(orgInfo.getShortName()).append("】。").append(intro);

            String content = msg.toString();
            String response = WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            log.info("wechat - return subscribe event response:{}", response);
            return response;
        } catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

    private Integer saveToDb(UploadResult uploadResult, MIMEType mimeType) {
        List<UploadFile> uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return 0;
        }
        UploadFile uploadFile = uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(uploadFile.getSize());
        orgStorage.setMimeType(mimeType.getCode());
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(DeleteStatus.NORMAL.getValue());
        orgStorage.setSource((short) 0);
        orgStorageDao.save(orgStorage, true);
        return orgStorage.getId();
    }

    /**
     * @Description : 微信消息重试机制判断 对重复收到的消息不再处理
     * @Author : zhenyujian
     * @Date : 2015年12月14日 下午4:51:43
     *
     * @Return : boolean
     */
    public boolean isFirstTimeHandle(String key) {
        log.info("Wechat - isFirstTimeHandle - check - key:{}", key);
        RedisConnection connection = redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB());

            if (connection.exists(key.getBytes())) {
                return false;
            } else {
                connection.setEx(key.getBytes(), 20, "".getBytes());
                return true;
            }
        } catch (Exception e) {
            log.error("Wechat - isFirstTimeHandle - exception - e:{}", e);
            return true;
        } finally {
            RedisConnectionUtils.releaseConnection(connection, redisTemplate.getConnectionFactory());
        }
    }

    /**
     * @Description : 判断粉丝是否已保存到数据库 若无，则保存
     * @Author : zhenyujian
     * @Date : 2015年12月14日 下午5:01:39
     *
     * @Return : Fans
     */
    public Fans fansPretreatment(WechatAbstractMessage message) {
        Fans fans = null;

        fans = fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(message.getToUserName());
            if (authorizerInfo == null || !authorizerInfo.isPassedVerify()
                || authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
                return null;
            }

            AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            if (authorizationInfo == null || !authorizationInfo.hasFunc(WechatPermission.USER_MANAGE.getValue())) {
                return null;
            }
            try {
                fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(),
                    message.getFromUserName());
            } catch (Exception e) {
            }
            if (fans == null) {
                return null;
            }
            fans.initBasicAttribute();
            if ((message instanceof WechatOrdinaryMessage)) {
                fans.setLastCommunicationTime(new Date());
            } else {
                fans.setLastCommunicationTime(new Date(0));
            }
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            if (StringUtils.isNotBlank(fans.getHeadImgUrl()) && WechatProperties.getSwitchFansImgConvert()) {
                try {
                    MIMEType mime = MIMEType.JPG;
                    UploadResult result = FileUploadUtils.uploadToRemote(0L, fans.getHeadImgUrl(), MIMEType.JPG, false);
                    UploadFile uploadFile = result.getFiles().get(0);
                    saveToDb(result, mime);
                    String headImgUrlGsx = StorageUtil.constructUrl(uploadFile.getFid(), uploadFile.getSn(), mime.getCode());
                    fans.setHeadImgUrlGsx(headImgUrlGsx);
                } catch (Exception e) {
                    log.warn("fansPretreatment - headImgUrlGsx - exception:{}", e);
                }
            } else {
                fans.setHeadImgUrlGsx("");
            }

            try {
                fansDao.save(fans, true);
            } catch (DuplicateKeyException ce) {
                fans = fansDao.getByOpenId(message.getFromUserName());
            }
            log.info("wechat - MessageReceiveServiceImpl - save fans - fans:{}", fans);

        } else {
            if (message instanceof WechatOrdinaryMessage) {
                fans.setLastCommunicationTime(new Date());
                fans.setSubscribe(1);
                log.info("wechat - MessageReceiveServiceImpl - WechatOrdinaryMessage - update fans - fans:{}", fans);
                fansDao.update(fans, true);
            } else if (message instanceof WechatEventMessage) {
                switch (((WechatEventMessage) message).getEvent()) {
                    // 用户关注事件
                    case SUBSCRIBE: {
                        if (fans.getSubscribe().intValue() != 1) {
                            fans.setSubscribe(1);
                            fans.setSubscribeTime(new Date());
                            // fans.setLastCommunicationTime(new Date());
                            log.info("wechat - MessageReceiveServiceImpl - SUBSCRIBE - update fans - fans:{}", fans);
                            fansDao.update(fans, true);
                        }
                        break;
                    }

                    // 用户取消关注事件
                    case UNSUBSCRIBE: {
                        fans.setSubscribe(0);
                        log.info("wechat - MessageReceiveServiceImpl - UNSUBSCRIBE - update fans - fans:{}", fans);
                        fansDao.update(fans, true);
                        break;
                    }

                    default: {
                        break;
                    }
                }
            }
        }

        return fans;
    }

    /**
     * @Description : 消息队列bean 初始化
     * @Author : zhenyujian
     * @Date : 2015年12月14日 下午4:59:22
     *
     * @Return : void
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties("mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"),
            											 mnsProperties.getProperty("mns.accesskeysecret"), 
            											 mnsProperties.getProperty("mns.accountendpoint"));
            consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consult.msg.queue"));
        } catch (Exception e) {
            log.error("init cloud account error:" + e);
        }
    }

    @Override
    public void pushConsultation(String orgNumber, String openId) {
        // OrgAccount orgAccount = orgAccountDao.getAccountByNumber(Integer.parseInt(orgNumber+""));
        // if(orgAccount!=null){
        // AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgAccount.getId());
        // if(authorizerInfo!=null){
        // Fans fans = fansDao.getByOpenId(openId);
        // MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.currentUnixTimestamp(),
        // authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(),
        // openId, fans.getShowName(), fans.getHeadImgUrl());
        // dto.setTextContent("您有一条微信商机，快去牢牢抓住.");
        //
        // //调用推送接口
        // String msg = MessageSource.WECHAT.buildConsultTypeMsg( dto.toJson().toString() );
        // try{
        // consultMsgQueue.putMessage(new Message(msg));
        // log.info("put message to consultMsgQueue msg:{}", msg);
        // }catch(Exception e){
        // log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", msg,e);
        // }
        // }
        // }

    }

    // ***********************************
    // ***********************************
    // ******** 免费版 *************
    // ***********************************
    // ***********************************

    // 免费版公众号自定义菜单点击
    String menuClick4FreeVersion(AuthorizerInfo authorizerInfo, WechatEventMessage message) {
        if (freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            FreeVersionMenuClick obj = FreeVersionMenuClick.getByKey(message.getEventKey());
            if (obj == null) {
                log.error("freeVersion unknown click key");
                return null;
            }

            List<Long> orgIds = new ArrayList<Long>();
            StringBuilder reply = new StringBuilder();
            WechatOpenIdEntityType entityType = null;
            switch (obj) {
                case STUDNET_CENTER:
                    orgIds = wechatOpenIdRecordService.listOrgIdBy( authorizerInfo.getAuthorizerAppId(),
                    												message.getFromUserName(),
                    												WechatOpenIdEntityType.STUDENT);
                    entityType = WechatOpenIdEntityType.STUDENT;
                    break;

                case TEACHER_CENTER:
                    orgIds = wechatOpenIdRecordService.listOrgIdBy( authorizerInfo.getAuthorizerAppId(),
                    												message.getFromUserName(), 
                    												WechatOpenIdEntityType.TEACHER);
                    entityType = WechatOpenIdEntityType.TEACHER;
                    break;
            }

            List<Integer> orgIdsInteger = new ArrayList<Integer>();
            for (Long longId : orgIds) {
                if (authorizationInfoDao.getByOrgId(longId.intValue()) == null) {
                    orgIdsInteger.add(longId.intValue());
                }
            }

            if (CollectionUtils.isEmpty(orgIdsInteger)) {
                reply.append("你还没有绑定的机构哦！可以通过以下方式绑定机构：").append("\n").append("扫描机构的二维码，或直接在对话框中输入机构的天校号就可以了！");
            } else {
                List<OrgInfo> orgInfos = orgInfoDao.getOrgInfos(orgIdsInteger);
                List<OrgCenterInfo> list = OrgCenterInfo.convertBy(authorizerInfo.getAuthorizerAppId(), orgInfos, entityType);

                if (CollectionUtils.isNotEmpty(list)) {
                    reply.append("想要查看哪个机构,点击机构名称直接访问");
                }

                boolean useShortUrl = false;
                String url = null;
                if (list.size() > 1) {// 超过2个 就是用短链接 避免回复内容超长
                    useShortUrl = true;
                }

                for (OrgCenterInfo cInfo : list) {
                    if (useShortUrl) {
                        url = ShortUrlUtil.getShortUrl(cInfo.getUrl());
                    } else {
                        url = cInfo.getUrl();
                    }
                    reply.append("\n\n").append(getHrefLink(url, cInfo.getOrgShortName()));

                }
            }

            return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), reply.toString());
        }
        return null;
    }

    // 公众号输入天校号后 回复
    String txNumerReply4FreeVersion(AuthorizerInfo authorizerInfo, WechatTextMessage message) {
        if (freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {

            String keywordReply = getKeywordReply(message, authorizerInfo);
            if (keywordReply != null) {
                return keywordReply;
            }

            if (!message.getContent().contains("\\.") && NumberUtils.isNumber(message.getContent())) {
                OrgInfo orgInfo = orgInfoDao.getByExtension(message.getContent());
                if (orgInfo != null && freeVersionService.isFreeAccount(orgInfo.getOrgId())) {
                    OrgAccount org = orgAccountDao.getById(orgInfo.getOrgId());
                    String url = OrgCenterInfo.getCenterSelectUrl(org.getId().longValue(), authorizerInfo.getAuthorizerAppId());
                    return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(),
                    									  orgInfo.getShortName() + ": 需要您完善一下信息哦!", "", WechatProperties.getOrgCenterImg(), url);
                } else {
                    return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(),
                        "机构不存在。 请核对机构天校号后重新输入,或扫码关注。");
                }
            } else {
                return generateDefaultResponse();
            }
        }
        return null;
    }

    // 公众号输入天校号后 回复
    String orgIdQrCodeReply4FreeVersion(AuthorizerInfo authorizerInfo, WechatEventMessage message, Integer orgId) {
        if (freeVersionService.isFreeAccount(authorizerInfo.getAuthorizerAppId())) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);

            if (orgInfo != null && freeVersionService.isFreeAccount(orgInfo.getOrgId())) {
                OrgAccount org = orgAccountDao.getById(orgInfo.getOrgId());
                String url = OrgCenterInfo.getCenterSelectUrl(org.getId().longValue(), authorizerInfo.getAuthorizerAppId());
                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(),
                									  orgInfo.getShortName() + ": 需要您完善一下信息哦!", "", WechatProperties.getOrgCenterImg(), url);
            } else {
                return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(),
                    "机构不存在。 请核对机构天校号后重新输入,或扫码关注。");
            }
        }
        return null;
    }

}