/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.dao.ComponentVerifyTicketDao;
import com.baijia.tianxiao.dal.wechat.po.ComponentVerifyTicket;
import com.baijia.tianxiao.sal.wechat.api.ComponentVerifyTicketService;

/**   
 * @Title       : ComponentVerifyTicketServiceImpl 
 * @Description : 见 https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318587&lang=zh_CN
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午2:05:57 
 */
@Service
public class ComponentVerifyTicketServiceImpl implements ComponentVerifyTicketService {

    private static final Logger logger = LoggerFactory.getLogger(ComponentVerifyTicketServiceImpl.class);

    @Autowired
    private ComponentVerifyTicketDao componentVerifyTicketDao;

    
    
    @Transactional(readOnly = true)
    @Override
    public ComponentVerifyTicket getByAppId(String appId) {
        return componentVerifyTicketDao.getByAppId(appId);
    }

    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveOrUpdate(ComponentVerifyTicket newTicket) {
        ComponentVerifyTicket ticket = getByAppId(newTicket.getAppId());
        if (ticket == null) {
            componentVerifyTicketDao.save(newTicket,true);
            logger.info("wechat - add new component verify ticket:{}", newTicket);
            return;
        }

        ticket.setComponentVerifyTicket(newTicket.getComponentVerifyTicket());
        ticket.setCreateTime(newTicket.getCreateTime());
        ticket.setInfoType(newTicket.getInfoType());
        componentVerifyTicketDao.update(ticket,true);
        logger.info("wechat - update component verify ticket:{}", ticket);
    }
}
