/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.sendmsg.batch;

import net.sf.json.JSONObject;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;

/**   
 * @Title       : OpenPlatformApiCaller 
 * @Description : 微信公众平台 发送消息 - 群发接口
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 上午11:01:58 
 */
public class BatchMsgApiCaller {
	
	
	/**
	 * @Description  : 群发图文消息
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月3日 上午11:03:49 
	 *
	 * @Return       : 
	 */
	public static WechatApiResponse sendMediaNews(String accessToken, String mediaId, Integer groupId)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=" + accessToken;
        
        JSONObject json = new JSONObject();
        JSONObject filter = new JSONObject();
        if(groupId!=null){
        	filter.put("is_to_all", false);
        	filter.put("group_id", groupId);
        }else{
        	filter.put("is_to_all", true);
        	filter.put("group_id", 0);
        }
        JSONObject mpnews = new JSONObject();
        mpnews.put("media_id", mediaId);
        
        json.put("filter", filter);
        json.put("mpnews", mpnews);
        json.put("msgtype", "mpnews");
        
        return WechatRemoteCallHelper.postJsonObj(url, JSONObject.fromObject(json));
    }
	
}

