/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.request;

import java.util.Date;

import lombok.Data;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import com.baijia.tianxiao.util.date.DateUtil;

@Data
public class AuthorizationReceiveDto{
	
	private String appId;
    private String infoType;
    private Date createTime;
    private String authorizerAppid;
    private String componentVerifyTicket;
    
    
    public static AuthorizationReceiveDto buildByXml(String xml) throws DocumentException{
    	Document document = DocumentHelper.parseText(xml);
    	Element root = document.getRootElement();
    	
    	String appId                 = root.elementTextTrim("AppId");
    	String infoType              = root.elementTextTrim("InfoType");
    	String createTime            = root.elementTextTrim("CreateTime");
    	String authorizerAppid       = root.elementTextTrim("AuthorizerAppid");
    	String componentVerifyTicket = root.elementTextTrim("ComponentVerifyTicket");
    	
    	AuthorizationReceiveDto dto = new AuthorizationReceiveDto();
    	dto.setAppId( appId );
    	dto.setInfoType( infoType );
    	dto.setCreateTime( DateUtil.UnixTimestamp2Date(Long.parseLong(createTime)) );
    	dto.setAuthorizerAppid( authorizerAppid );
    	dto.setComponentVerifyTicket( componentVerifyTicket );

        return dto;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
