/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title : QRCodeSceneStrSubscribeOrg
 * @description : 带机构id参数 - 关注二维码
 * @author : zhenyujian
 * @date : 2016年1月28日 下午2:20:50
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class QRCodeSceneStrSubscribeOrg extends QRCodeSceneStr {

    private static final String JSON_KEY_ORIGIN_ORG_ID = "orgid";

    private Integer orgId;

    public QRCodeSceneStrSubscribeOrg() {
        super.qrCodeType = QRCodeType.SUBCRIBE_WITH_ORG_ID;
    }

    public QRCodeSceneStrSubscribeOrg(Integer orgId) {
        super.qrCodeType = QRCodeType.SUBCRIBE_WITH_ORG_ID;
        this.orgId = orgId;
    }

    public String getSceneStr() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getSceneStr());
        builder.append(QRCodeSceneStr.createSceneStrParam(JSON_KEY_ORIGIN_ORG_ID, this.orgId));
        return builder.toString();
    }

    public static QRCodeSceneStrSubscribeOrg fromSceneStr(String str) {
        QRCodeSceneStrSubscribeOrg dto = new QRCodeSceneStrSubscribeOrg();
        dto.setOrgId(Integer.parseInt(QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_ORIGIN_ORG_ID)));
        return dto;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
    
    public static void main(String args[]){
    	QRCodeSceneStrSubscribeOrg a= fromSceneStr("qr=orgid_orgid=4016_");
    	System.out.println(a);
    }
}
