/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.custommenu;

import java.util.List;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import lombok.Data;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.MenuCustomJsonKey;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;

@Data
public class CustomMenuBtn {
	
	private MediaType type;
	private String name;
	private String url;
	private String content;
	private String note;
	private String mediaId;
	private String key;
	private List<CustomMenuBtn> subButton; 
	
	
	public static CustomMenuBtn buildViewBtn(MediaType type, OrgWechatDto orgWechatDto){
		CustomMenuBtn btn = new CustomMenuBtn();
		btn.setName(type.getLabel());
		btn.setType(type);
		btn.setUrl(type.getUrl(orgWechatDto));
		btn.setNote(type.getNote());
		return btn;
	}
	
	public static CustomMenuBtn buildHierarchyBtn(MediaType type, OrgWechatDto orgWechatDto, List<CustomMenuBtn> subButton){
		CustomMenuBtn btn = new CustomMenuBtn();
		btn.setName(type.getLabel());
		btn.setNote(type.getNote());
		btn.setSubButton(subButton);
		return btn;
	}
	
	public static CustomMenuBtn buildTextBtn(MediaType type, String content, OrgWechatDto orgWechatDto){
		CustomMenuBtn btn = new CustomMenuBtn();
		btn.setName(type.getLabel());
		btn.setType(type);
		btn.setContent(content);
		btn.setNote(type.getNote()+content);
		return btn;
	}
	
	
	public JSONObject toJson(){
		JSONObject json = new JSONObject();
		if(type!=null){
			json.put(MenuCustomJsonKey.TYPE, type.getValue());
		}
		json.put(MenuCustomJsonKey.NAME, name);
		json.put(MenuCustomJsonKey.MEDIA_ID, mediaId);
		json.put(MenuCustomJsonKey.NOTE, note);
		json.put(MenuCustomJsonKey.CONTENT, content);
		json.put(MenuCustomJsonKey.URL, url);
		if(subButton!=null && !subButton.isEmpty()){
			JSONArray subBtnArray = new JSONArray();
			for(CustomMenuBtn btn : subButton){
				subBtnArray.add( btn.toJson() );
			}
			json.put(MenuCustomJsonKey.SUB_BUTTON, subBtnArray);
		}
		return json;
	}	
	
	public String toJsonStr(){
		return toJson().toString();
	}
	
	
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
	
}

