/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.wechatmsg;

import lombok.extern.slf4j.Slf4j;


/**   
 * @title       : WechatMsgType 
 * @description : 微信消息类型 
 * 				  http://mp.weixin.qq.com/wiki/17/f298879f8fb29ab98b2f2971d42552fd.html#.E6.96.87.E6.9C.AC.E6.B6.88.E6.81.AF
 * @author      : zhenyujian
 * @date        : 2016年1月12日 下午8:05:42 
 */
@Slf4j
public enum WechatMsgType{
	
	UNKNOWN("unknown"),
	
	TEXT("text"),
	
	IMAGE("image"),
	
	VOICE("voice"),
	
	VIDEO("video"),
	
	SHORT_VIDEO("shortvideo"),
	
	LOCATION("location"),
	
	LINK("link"),
	
	EVENT("event"),
	;
	
	
    private String value;
    
    public static WechatMsgType getByVaule(String value){
		for (WechatMsgType type : WechatMsgType.values()) {
			if(type.getValue().equals(value)){
				return type;
			}
        }
		log.warn("unknown WechatMsgType value:{}", value);
    	return UNKNOWN;
    }
    
    
    private WechatMsgType(String value) {
        this.value = value;
    }
    public String getValue() {
        return this.value;
    }
}

