/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;


/**   
 * @title       : WechatMediaType 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午6:24:50 
 */
public enum MediaType {
	
	//自定义类型 (用于自动回复空对象占位)
	UNKNOWN(0, "", "未知", false, false),
	
	//微信的素材类型 (用于微信api  str字段为微信接口定义)
    IMAGE(1, "image", "图片", false, false),
    VOICE(2, "voice", "语音", false, false),
    VIDEO(3, "video", "视频", false, false),
    THUMB(4, "thumb", "缩略图", false, false),
    NEWS (5, "news" , "图文素材", false, false),
    
    
    //自定义类型
    CONTENT (6, "" , "文本", false, false),
    ZIDINGYILIANJIE (15, "" , "自定义链接", true, false),
    
    WANGXIAOZHUYE   (11, "" , "网校主页", true, false),
    KECHENGDANYE    (12, "" , "课程单页", true, false),
    HUODONG         (13, "" , "活动", true, false),
    KECHENGLIEBIAO  (14, "" , "课程列表", true, false),
    WODEKEBIAO      (16, "" , "我的课表", true, true),
    WODEQIANDAO     (17, "" , "我的签到", true, true),
    WODEPINGJIA     (18, "" , "我的评价", true, true),
    
    WEIGUANWANG     (19, "" , "微官网", true, false),//因为android端 也写了一个枚举类 不支持扩展。。  里面的自定义链接类型定死为15
    XIAOQUDIZHI     (20, "" , "校区地址", true, false),
    DIANHUA         (21, "" , "400电话", false, false),
    ZAIXIANZIXUN    (22, "" , "在线咨询", false, false),
    
    YUYUESHITING    (23, "" , "预约试听", true, false),
    
    GERENZHONGXIN   (24, "" , "个人中心", true, true),
    XUESHENGZHONGXIN(25, "" , "学生中心", true, true),
    LAOSHIZHONGXIN  (26, "" , "老师中心", true, true),
    
    ;
	
	public static MediaType getByVaule(int value){
		for (MediaType type : MediaType.values()) {
			if(type.getValue() == value){
				return type;
			}
        }
    	return null;
    }
	
	public static MediaType getByLabel(String label){
		for (MediaType type : MediaType.values()) {
			if(type.getLabel().equals(label)){
				return type;
			}
        }
    	return null;
    }

    private int value;
    private String str;//微信api key值
    private String label;
    private boolean needUrl;//是否需要指定url
    private boolean webauth;//是否需要微信网页授权权限

    private MediaType(int value, String str, String label,boolean needUrl, boolean webauth) {//str字段为微信接口定义 只有微信定义的素材类型存在该值
        this.value = value;
        this.str = str;
        this.label = label;
        this.webauth = webauth;
    }

    public int getValue() {
        return this.value;
    }
    
    public String getStr(){
    	return this.str;
    }

    public String getLabel() {
        return this.label;
    }
    
    
    public boolean isNeedUrl() {
		return needUrl;
	}

	public void setNeedUrl(boolean needUrl) {
		this.needUrl = needUrl;
	}

	public boolean isWebauth() {
		return webauth;
	}

	public void setWebauth(boolean webauth) {
		this.webauth = webauth;
	}
	
	public String getNote(){
		String fmt = "[%s]";
		return String.format(fmt, this.label);
	}

	public String getUrl(OrgWechatDto orgWechatDto){
    	switch(this){
			case WANGXIAOZHUYE:
				String fmt1 = "%s%s%s";
				return String.format(fmt1, WechatProperties.getWebMTianXiaoUrlPrefix(), "i/" ,orgWechatDto.getOrgNumber());
				
			case KECHENGLIEBIAO:
				String fmt2 = "%s%s%s";
				return String.format(fmt2, WechatProperties.getWebMTianXiaoUrlPrefix(), "course/" ,orgWechatDto.getOrgNumber());
				
			case WODEKEBIAO:
				return WechatWebAuthLinkBuilder.schedule(WebAuthScope.BASE, orgWechatDto.getAppId());
				
			case WODEQIANDAO:
				return WechatWebAuthLinkBuilder.mySigninRecord(WebAuthScope.BASE, orgWechatDto.getAppId());
				
			case WODEPINGJIA:
				return WechatWebAuthLinkBuilder.rating(WebAuthScope.BASE, orgWechatDto.getAppId());
				
			case XUESHENGZHONGXIN:
				return WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, orgWechatDto.getAppId());
				
			case LAOSHIZHONGXIN:
				return WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, orgWechatDto.getAppId());
				
			case XIAOQUDIZHI:
				String fmt3 = "%s%s%s";
				return String.format(fmt3, WechatProperties.getWebMTianXiaoUrlPrefix(), "branch/" ,orgWechatDto.getOrgNumber());
				
			case YUYUESHITING:
				String fmt4 = "%s%s?orgNumber=%s";
				return String.format(fmt4, WechatProperties.getWebCRMUrlPrefix(), "consult/view.do" ,orgWechatDto.getOrgNumber());
				
			default :
				return null;
    	}
    }
	
	public static String fillUrlWithHttp(String url){
        if (StringUtils.isNotBlank(url)) {
            if (!url.startsWith("http://")) {
                url = "http://" + url;
            }
        }
        return url;
	}
}