/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoCallbackHandler;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgType;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationInfoCallbackRequest;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReleaseTestImpl
implements ReleaseTest {
    private static final Logger log = LoggerFactory.getLogger(ReleaseTestImpl.class);
    private static final String RELEASE_TEST_APP_ID = "wx570bc396a51b8ff8";
    @Autowired
    private AuthorizationInfoCallbackHandler handler;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setAuthCode(String authCode, Integer expiresIn) {
        String orgNum = WechatProperties.getKeyOpenAuthCodeCallBackTestNum();
        OrgAccount account = this.orgAccountDao.getAccountByNumber(Integer.valueOf(Integer.parseInt(orgNum)), new String[0]);
        if (account == null) {
            throw new IllegalArgumentException("account is null, orgNum: " + orgNum);
        }
        AuthorizationInfoCallbackRequest cbRequest = new AuthorizationInfoCallbackRequest();
        cbRequest.setOrgId(account.getId());
        cbRequest.setAuthCode(authCode);
        cbRequest.setExpiresIn(expiresIn);
        this.handler.handleTest(cbRequest);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String handleTestMsg(WechatAbstractMessage message) {
        try {
            String content = "";
            content = message.getMsgType() == WechatMsgType.EVENT ? this.getEventResponse((WechatEventMessage)message) : this.getOrdinaryResponse((WechatOrdinaryMessage)message);
            String response = PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.toString());
            throw e;
        }
    }

    private String getOrdinaryResponse(WechatOrdinaryMessage message) {
        if (message.getMsgType() == WechatMsgType.TEXT) {
            return this.getTextResponse((WechatTextMessage)message);
        }
        return "";
    }

    private String getTextResponse(WechatTextMessage message) {
        String content = message.getContent();
        if (content.indexOf("TESTCOMPONENT_MSG_TYPE_TEXT") >= 0) {
            return this.getImmediateMessageResponse(message);
        }
        String QUERY_AUTH_CODE = "QUERY_AUTH_CODE:";
        int idx = content.indexOf("QUERY_AUTH_CODE:");
        if (idx >= 0) {
            String authCode = message.getContent().substring(idx + "QUERY_AUTH_CODE:".length());
            return this.getCustomerMessageResponse(authCode, message);
        }
        return "";
    }

    private String getEventResponse(WechatEventMessage message) {
        return (Object)((Object)message.getEvent()) + "from_callback";
    }

    private String getImmediateMessageResponse(WechatTextMessage message) {
        return message.getContent() + "_callback";
    }

    private String getCustomerMessageResponse(String authCode, WechatTextMessage message) {
        this.setAuthCode(authCode, 600);
        this.callTestCustomer(RELEASE_TEST_APP_ID, message.getFromUserName(), authCode);
        return "";
    }

    private void callTestCustomer(String appId, String toUser, String authCode) {
        AuthorizationInfo info = this.authorizationInfoDao.getByAuthorizerAppId(appId);
        CustomerServiceApiHelper.sendTextMsg(info.getAuthorizerAccessToken(), toUser, authCode + "_from_api");
    }
}

