/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.FreeVersionService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FreeVersionServiceImpl
implements FreeVersionService {
    private static final Logger log = LoggerFactory.getLogger(FreeVersionServiceImpl.class);
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;

    @Override
    public boolean isFreeAccount(Integer orgId) {
        TXAccount txAccount;
        Integer target = (int)orgId;
        OrgSubAccount subAccount = this.orgSubAccountDao.getByOrgId(orgId);
        if (subAccount != null && subAccount.getPid() != null && subAccount.getPid() > 0) {
            target = subAccount.getPid();
        }
        if ((txAccount = this.txAccountDao.getByOrgId(target)) == null) {
            log.error("txAccount is null orgId:{},target:{}", (Object)orgId, (Object)target);
            return false;
        }
        return txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue();
    }

    @Override
    public AuthorizerInfo getFAAuthorizerInfo(Integer orgId) {
        String appid = WechatProperties.getWechatAppidForFreeVersion();
        return this.authorizerInfoDao.getByAuthorizerAppId(appid);
    }
}

