/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomMenuService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuBtn;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuDto;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import java.io.Serializable;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomMenuServiceImpl
implements CustomMenuService {
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public boolean syncCustomMenu(int orgId) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAndBuildCustomMenu(int orgId, String menuJson) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);
        OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizationInfo.getOrgId().intValue(), new String[0]);
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizationInfo.getAuthorizerAppId());
        MenuConvertResult result = WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, menuJson);
        Date now = new Date();
        if (result.getWechatJson() != null) {
            if (menu == null) {
                menu = new OrgWechatCustomMenu();
                menu.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
                menu.setCreateTime(now);
                menu.setUpdateTime(now);
                menu.setJson(result.getCustomJson());
                this.orgWechatCustomMenuDao.save((Object)menu, Boolean.valueOf(true), new String[0]);
            } else {
                menu.setUpdateTime(now);
                menu.setJson(result.getCustomJson());
                this.orgWechatCustomMenuDao.update((Object)menu, Boolean.valueOf(true), new String[0]);
            }
            WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), result.getWechatJson());
        } else if (menu != null) {
            this.orgWechatCustomMenuDao.delById((Serializable)menu.getId());
            WechatMenuApiHelper.deleteMenu(authorizationInfo.getAuthorizerAccessToken());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CustomMenuDto getCustomMenu(int orgId) {
        CustomMenuDto dto = null;
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);
        OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
        if (menu != null) {
            dto = new CustomMenuDto();
            dto.setAuthorizerAppId(menu.getAuthorizerAppId());
            dto.setCreateTime(menu.getCreateTime());
            dto.setId(menu.getId());
            dto.setJson(menu.getJson());
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public String getQuickMenuJson(int orgId) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        JSONObject json = new JSONObject();
        JSONArray btnArray = new JSONArray();
        btnArray.add((Object)CustomMenuBtn.buildViewBtn(MediaType.WANGXIAOZHUYE, orgWechatDto).toJson());
        btnArray.add((Object)CustomMenuBtn.buildViewBtn(MediaType.KECHENGLIEBIAO, orgWechatDto).toJson());
        if (authorizerInfo.hasWebAuthPermission()) {
            btnArray.add((Object)CustomMenuBtn.buildViewBtn(MediaType.GERENZHONGXIN, orgWechatDto).toJson());
        }
        json.put((Object)"list", (Object)btnArray);
        return json.toString();
    }
}

