/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.statistics;

import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSummaryDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiCaller;
import com.baijia.tianxiao.util.date.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class DataStatisticsApiHelper {
    public static FansSCDto getFansSCDto(String accessToken, Date beginDate, Date endDate, Date dateForCumulate) throws ParseException {
        JSONObject ytCumulateRootNode;
        JSONArray ytCumulateArray;
        FansSCDto dto = new FansSCDto();
        dto.setStartDate(DateUtil.getStrByDate((Date)beginDate));
        dto.setEndDate(DateUtil.getStrByDate((Date)endDate));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        WechatApiResponse ytCumulateResp = DataStatisticsApiCaller.getFansCumulate(accessToken, dateForCumulate, dateForCumulate);
        WechatApiResponse ytSummaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, dateForCumulate, dateForCumulate);
        int cancelFansForCumulate = 0;
        int newFansForCumulate = 0;
        int totalFansForCumulate = 0;
        JSONObject ytSummaryRootNode = ytSummaryResp.getRootJSONObj();
        JSONArray ytSummaryArray = ytSummaryRootNode.getJSONArray("list");
        if (ytSummaryArray != null && ytSummaryArray.size() > 0) {
            for (int i = 0; i < ytSummaryArray.size(); ++i) {
                JSONObject obj = ytSummaryArray.getJSONObject(i);
                cancelFansForCumulate += obj.getInt("cancel_user");
                newFansForCumulate += obj.getInt("new_user");
            }
        }
        if ((ytCumulateArray = (ytCumulateRootNode = ytCumulateResp.getRootJSONObj()).getJSONArray("list")) != null && !ytCumulateArray.isEmpty()) {
            totalFansForCumulate = ytCumulateArray.getJSONObject(0).getInt("cumulate_user");
        }
        dto.setYtDate(sdf.format(dateForCumulate));
        dto.setYtCancelFans(cancelFansForCumulate);
        dto.setYtNewFans(newFansForCumulate);
        dto.setYtFansDiff(newFansForCumulate - cancelFansForCumulate);
        dto.setYtCumulateFans(totalFansForCumulate);
        ArrayList<FansSummaryDto> fansSummaryDtoList = new ArrayList<FansSummaryDto>();
        List dateList = DateUtil.getDateBetween((Date)beginDate, (Date)endDate);
        if (dateList != null && !dateList.isEmpty()) {
            LinkedHashMap<String, FansSummaryDto> symmaryMap = new LinkedHashMap<String, FansSummaryDto>();
            for (Date date : dateList) {
                FansSummaryDto fansSummaryDto = new FansSummaryDto(sdf.format(date));
                symmaryMap.put(sdf.format(date), fansSummaryDto);
            }
            WechatApiResponse summaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, beginDate, endDate);
            JSONObject summaryRootNode = summaryResp.getRootJSONObj();
            JSONArray summaryArray = summaryRootNode.getJSONArray("list");
            if (summaryArray != null & !summaryArray.isEmpty()) {
                for (int i = 0; i < summaryArray.size(); ++i) {
                    JSONObject obj = summaryArray.getJSONObject(i);
                    FansSummaryDto fsdto = (FansSummaryDto)symmaryMap.get(obj.getString("ref_date"));
                    fsdto.setCancelFans(fsdto.getCancelFans() + obj.getInt("cancel_user"));
                    fsdto.setNewFans(fsdto.getNewFans() + obj.getInt("new_user"));
                    fsdto.setFansDiff(fsdto.getNewFans() - fsdto.getCancelFans());
                }
            }
            for (FansSummaryDto fsdto : symmaryMap.values()) {
                fansSummaryDtoList.add(fsdto);
            }
        }
        dto.setSummary(fansSummaryDtoList);
        return dto;
    }
}

