/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuBtnBuilder;
import com.baijia.tianxiao.sal.wechat.util.RandomUtil;
import com.baijia.tianxiao.sal.wechat.validator.CustomMenuValidator;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class WechatMenuJsonConverter {
    public static MenuConvertResult customJsonToWechatMenuJson(OrgWechatDto orgWechatDto, String menuJsonStr) {
        if (StringUtils.isBlank((CharSequence)menuJsonStr) || menuJsonStr.equals("{}")) {
            return new MenuConvertResult(menuJsonStr.toString(), null);
        }
        JSONObject wechatMenuJson = new JSONObject();
        JSONArray wechatBtnArray = new JSONArray();
        JSONObject menuJson = JSONObject.fromObject((Object)menuJsonStr);
        JSONArray btnArray = menuJson.optJSONArray("list");
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(menuJsonStr.toString(), null);
        }
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject wechatBtn = null;
                JSONObject btn = btnArray.getJSONObject(i);
                if (btn.get("subButton") == null || btn.get("subButton").equals("null") || btn.getJSONArray("subButton").size() == 0) {
                    CustomMenuValidator._4ButtonName(btn.getString("name"));
                    wechatBtn = WechatMenuJsonConverter.btnToWechatBtn(orgWechatDto, btn);
                } else {
                    wechatBtn = new JSONObject();
                    wechatBtn.put((Object)"name", (Object)btn.getString("name"));
                    wechatBtn.put((Object)"sub_button", (Object)WechatMenuJsonConverter.subBtnToWechatSubBtn(orgWechatDto, btn.getJSONArray("subButton")));
                    btn.remove("mediaType");
                    btn.remove("mediaId");
                    btn.remove("content");
                    btn.remove("url");
                }
                wechatBtnArray.add((Object)wechatBtn);
            }
        }
        wechatMenuJson.put((Object)"button", (Object)wechatBtnArray);
        return new MenuConvertResult(menuJson.toString(), wechatMenuJson.toString());
    }

    private static JSONArray subBtnToWechatSubBtn(OrgWechatDto orgWechatDto, JSONArray subBtnArray) {
        JSONArray wechatSubBtnArray = new JSONArray();
        if (subBtnArray != null && !subBtnArray.isEmpty()) {
            for (int i = 0; i < subBtnArray.size(); ++i) {
                CustomMenuValidator._4SubButtonName(subBtnArray.getJSONObject(i).getString("name"));
                JSONObject wechatSubBtn = WechatMenuJsonConverter.btnToWechatBtn(orgWechatDto, subBtnArray.getJSONObject(i));
                if (wechatSubBtn == null) continue;
                wechatSubBtnArray.add((Object)wechatSubBtn);
            }
        }
        return wechatSubBtnArray;
    }

    private static JSONObject btnToWechatBtn(OrgWechatDto orgWechatDto, JSONObject btn) {
        JSONObject wechatBtn = null;
        MediaType type = MediaType.getByVaule(btn.getInt("mediaType"));
        if (MediaType.UNKNOWN == type) {
            return null;
        }
        String name = btn.optString("name", "");
        String mediaId = btn.optString("mediaId", "");
        String url = btn.optString("url", "");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = type.getLabel();
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = type.getUrl(orgWechatDto);
        }
        if (MediaType.IMAGE == type) {
            wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
        } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type) {
            if (MediaType.NEWS == type) {
                wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
            } else if (MediaType.CONTENT == type) {
                String key = RandomUtil.str(10);
                wechatBtn = WechatMenuBtnBuilder.clickBtn(name, key);
                btn.put((Object)"clickKey", (Object)key);
            } else if (MediaType.WANGXIAOZHUYE == type) {
                wechatBtn = WechatMenuBtnBuilder.viewBtn(name, url);
                btn.put((Object)"url", (Object)wechatBtn.getString("url"));
            } else if (MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) {
                if (!url.startsWith("http") && !url.startsWith("https")) {
                    url = "http://" + url;
                }
                wechatBtn = WechatMenuBtnBuilder.viewBtn(name, url);
                btn.put((Object)"url", (Object)wechatBtn.getString("url"));
            }
        }
        return wechatBtn;
    }

    public static Map<String, String> mapClickKeyVsContent(String menuJsonStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject menuJson = JSONObject.fromObject((Object)menuJsonStr);
        JSONArray btnArray = menuJson.optJSONArray("list");
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject btn = btnArray.getJSONObject(i);
                int type = btn.optInt("mediaType", -1);
                if (type == -1) {
                    JSONArray subBtnArray = btn.getJSONArray("subButton");
                    if (subBtnArray == null || subBtnArray.isEmpty()) continue;
                    for (int j = 0; j < subBtnArray.size(); ++j) {
                        btn = subBtnArray.getJSONObject(j);
                        type = btn.optInt("mediaType", -1);
                        if (type != MediaType.CONTENT.getValue()) continue;
                        map.put(btn.getString("clickKey"), btn.optString("content"));
                    }
                    continue;
                }
                if (type != MediaType.CONTENT.getValue()) continue;
                map.put(btn.getString("clickKey"), btn.optString("content"));
            }
        }
        return map;
    }

    public static void main(String[] args) {
        String a = "{\"b\":[]}";
        System.out.println(JSONObject.fromObject((Object)a).get("b"));
    }
}

