/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.media;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;

public class WechatMediaApiCaller {
    public static WechatApiResponse uploadTempMedia(String accessToken, MediaType type, File file) throws WechatException, WebServiceException {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/media/upload?");
        builder.append("&access_token=").append(accessToken);
        builder.append("&type=").append(type.getStr());
        return WechatRemoteCallHelper.postFile(builder.toString(), null, file);
    }

    public static byte[] downloadTempMedia(String accessToken, String mediaId) throws WechatException, WebServiceException, Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/media/get?");
        builder.append("&access_token=").append(accessToken);
        builder.append("&media_id=").append(mediaId);
        return HttpClientUtils.download((String)builder.toString());
    }

    public static WechatApiResponse uploadPermanentMedia(String accessToken, MediaType mediaType, File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/add_material?");
        builder.append("&access_token=").append(accessToken);
        builder.append("&type=").append(mediaType.getStr());
        return WechatRemoteCallHelper.postWechatPermanentMedia(builder.toString(), null, file, mediaType);
    }

    public static WechatApiResponse uploadPermanentNews(String accessToken, String json) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/add_news?");
        builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject((Object)json));
    }

    public static WechatApiResponse countPermanentMedia(String accessToken) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/get_materialcount?");
        builder.append("&access_token=").append(accessToken);
        return WechatRemoteCallHelper.get(builder.toString());
    }

    public static WechatApiResponse batchGetPermanentMedia(String accessToken, MediaType type, int offset, int count) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/batchget_material?");
        builder.append("&access_token=").append(accessToken);
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)type.getStr());
        json.put((Object)"offset", (Object)offset);
        json.put((Object)"count", (Object)count);
        return WechatRemoteCallHelper.postJsonObj(builder.toString(), json);
    }

    public static byte[] downloadPermanentMedia(String accessToken, String mediaId) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/get_material?");
        builder.append("&access_token=").append(accessToken);
        builder.append("&media_id=").append(mediaId);
        HashMap params = Maps.newHashMap();
        params.put("media_id", mediaId);
        return HttpClientUtils.downloadByPost((String)builder.toString(), (Map)params);
    }

    public static WechatApiResponse getPermanentMediaNews(String accessToken, String mediaId) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/get_material?");
        builder.append("&access_token=").append(accessToken);
        builder.append("&media_id=").append(mediaId);
        HashMap params = Maps.newHashMap();
        params.put("media_id", mediaId);
        return WechatRemoteCallHelper.postJson(builder.toString(), params);
    }

    public static WechatApiResponse delPermanentMediaNews(String accessToken, String mediaId) {
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/cgi-bin/material/del_material?");
        builder.append("&access_token=").append(accessToken);
        builder.append("&media_id=").append(mediaId);
        HashMap params = Maps.newHashMap();
        params.put("media_id", mediaId);
        return WechatRemoteCallHelper.postJson(builder.toString(), params);
    }

    public static void main(String[] args) {
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=Po2w3Y4PaZRnkuky46WnxSTqBBOBlWEOJW54oMp5FBn5MK3c3iX6A7qCqp4o_mQ__RSeikZOsO8T5Z74wvnQAunaMgw7FAQm4xhBGF4aHxwHTIbAJAWIX";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "image");
        params.put("offset", "0");
        params.put("count", "10");
        WechatApiResponse response = WechatRemoteCallHelper.postJson(url, params);
        System.out.println(response);
    }
}

