/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.util.FileUtil;
import java.io.File;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileHelper {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileHelper.class);

    public static File saveToLocal(byte[] data, MIMEType fileType) {
        return LocalFileHelper.saveToLocal(data, fileType.getExtension());
    }

    public static File saveToLocal(byte[] data, String extension) {
        try {
            String tmpDir = LocalFileHelper.getTmpDir();
            String tmpFile = String.valueOf(tmpDir) + File.separator + LocalFileHelper.random() + "." + extension;
            boolean ret = FileUtil.write(tmpFile, data);
            logger.debug("saveToLocal - tmpfile:{}, data.len:{}, result:{}", new Object[]{tmpFile, data.length, ret});
            return new File(tmpFile);
        }
        catch (Exception e) {
            logger.error("saveToLocal error", (Throwable)e);
            throw new RuntimeException("save to local exception - ", e);
        }
    }

    public static void deleteFile(File file) {
        file.delete();
        logger.debug("deleteFile - file:{}", (Object)file);
    }

    private static String getTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isBlank((CharSequence)tmpDir)) {
            tmpDir = WechatProperties.getUpLoadDefaultTmpdir();
        }
        logger.trace("getTmpDir - tmpdir:{}", (Object)tmpDir);
        return tmpDir;
    }

    private static int random() {
        Random r = new Random();
        return Math.abs(r.nextInt());
    }

    public static String getTmpFileName(String extension) {
        String tmpDir = LocalFileHelper.getTmpDir();
        String tmpFile = String.valueOf(tmpDir) + File.separator + LocalFileHelper.random() + "." + extension;
        return tmpFile;
    }
}

