/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import org.apache.commons.lang3.StringUtils;

public class EmojiUtil {
    public static boolean containsEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        int len = source.length();
        int i = 0;
        while (i < len) {
            char codePoint = source.charAt(i);
            if (!EmojiUtil.isNotEmojiCharacter(codePoint)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isNotEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        try {
            if (!EmojiUtil.containsEmoji(source)) {
                return source;
            }
            StringBuilder buf = null;
            int len = source.length();
            int i = 0;
            while (i < len) {
                char codePoint = source.charAt(i);
                if (EmojiUtil.isNotEmojiCharacter(codePoint)) {
                    if (buf == null) {
                        buf = new StringBuilder(source.length());
                    }
                    buf.append(codePoint);
                }
                ++i;
            }
            if (buf == null) {
                return source;
            }
            if (buf.length() == len) {
                buf = null;
                return source;
            }
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return source;
        }
    }
}

