/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.task;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FansSyncJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FansSyncJob.class);
    private FansService fansService;
    private AuthorizerInfoService authorizerInfoService;
    private String authorizerAppId;

    public FansSyncJob(FansService fansService, String authorizerAppId, AuthorizerInfoService authorizerInfoService) {
        this.fansService = fansService;
        this.authorizerInfoService = authorizerInfoService;
        this.authorizerAppId = authorizerAppId;
    }

    @Override
    public void run() {
        block8: {
            log.info("Wechat - FansSyncJob - run - start - authorizerAppId:{}", (Object)this.authorizerAppId);
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByAuthorizerAppId(this.authorizerAppId);
            if (authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
                return;
            }
            authorizerInfo.setFansSyncStatus(Integer.valueOf(WechatDataSyncStatus.ONGOING.getValue()));
            this.authorizerInfoService.update(authorizerInfo);
            try {
                this.fansService.syncFans(this.authorizerAppId);
                Thread.currentThread();
                Thread.sleep(5000L);
                this.fansService.batchConvertFansHeadImg(this.authorizerAppId);
            }
            catch (WechatException e) {
                log.error("Wechat - FansSyncJob - WechatException - e:{}", (Throwable)e);
                authorizerInfo.setFansSyncStatus(Integer.valueOf(WechatDataSyncStatus.END.getValue()));
                this.authorizerInfoService.update(authorizerInfo);
                break block8;
            }
            catch (Exception e) {
                try {
                    log.error("Wechat - FansSyncJob - Exception - e:{}", (Throwable)e);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    authorizerInfo.setFansSyncStatus(Integer.valueOf(WechatDataSyncStatus.END.getValue()));
                    this.authorizerInfoService.update(authorizerInfo);
                }
            }
            authorizerInfo.setFansSyncStatus(Integer.valueOf(WechatDataSyncStatus.END.getValue()));
            this.authorizerInfoService.update(authorizerInfo);
        }
        log.info("Wechat - FansSyncJob - run - end authorizerAppId:{}", (Object)this.authorizerAppId);
    }
}

