/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.composite.dao.CityDao;
import com.baijia.tianxiao.dal.composite.po.City;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMenu;
import com.baijia.tianxiao.sal.wechat.api.OrgWechatMenuService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgWechatMenuServiceImpl
implements OrgWechatMenuService {
    private static final Logger log = LoggerFactory.getLogger(OrgWechatMenuServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OrgWechatMenuServiceImpl.class);
    @Autowired
    private OrgWechatMenuDao orgWechatMenuDao;
    @Autowired
    private CityDao cityDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Integer id) {
        logger.info("wechat - del menu - id:{}", (Object)id);
        OrgWechatMenu menu = this.orgWechatMenuDao.getById(id.intValue());
        if (menu != null) {
            this.orgWechatMenuDao.delById((Serializable)menu.getId());
        } else {
            logger.warn("wechat - del null menu - id:{}", (Object)id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByOrgId(Integer orgId) {
        logger.info("wechat - del menu - orgId:{}", (Object)orgId);
        this.orgWechatMenuDao.deleteByOrgId(orgId.intValue());
    }

    @Override
    @Transactional(readOnly=true)
    public List<OrgWechatMenu> getByOrgId(Integer orgId) {
        return this.orgWechatMenuDao.getByOrgId(orgId.intValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDefaultMenu(Integer orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgWechatMenu course = this.addMenu(orgId, 1, 0, "\u673a\u6784\u8bfe\u7a0b", "");
        this.addMenu(orgId, 2, course.getId(), "\u5168\u90e8\u8bfe\u7a0b", this.getUrl(account, WechatProperties.getMOrgUrlCourse()));
        this.addMenu(orgId, 2, course.getId(), "\u641c\u7d22\u8bfe\u7a0b", this.getSearchUrl(orgInfo, WechatProperties.getMOrgUrlSearch()));
        OrgWechatMenu info = this.addMenu(orgId, 1, 0, "\u673a\u6784\u4fe1\u606f", "");
        this.addMenu(orgId, 2, info.getId(), "\u673a\u6784\u8001\u5e08", this.getUrl(account, WechatProperties.getMOrgUrlTeacher()));
        this.addMenu(orgId, 2, info.getId(), "\u673a\u6784\u7b80\u4ecb", this.getUrl(account, WechatProperties.getMOrgUrlIntro()));
        this.addMenu(orgId, 2, info.getId(), "\u673a\u6784\u76f8\u518c", this.getUrl(account, WechatProperties.getMOrgUrlPhoto()));
        this.addMenu(orgId, 2, info.getId(), "\u6821\u533a\u5730\u5740", this.getUrl(account, WechatProperties.getMOrgUrlBranches()));
        OrgWechatMenu online = this.addMenu(orgId, 1, 0, "\u5728\u7ebf\u670d\u52a1", "");
        this.addMenu(orgId, 2, online.getId(), "\u673a\u6784\u4e3b\u9875", this.getUrl(account, WechatProperties.getMOrgUrlHomePage()));
    }

    private OrgWechatMenu addMenu(Integer orgId, Integer level, Integer pid, String name, String url) {
        OrgWechatMenu menu = new OrgWechatMenu();
        menu.setOrgId(orgId);
        menu.setName(name);
        menu.setUrl(url);
        menu.setLevel(level);
        menu.setPid(pid);
        menu.setCreateTime(new Date());
        this.orgWechatMenuDao.save((Object)menu, Boolean.valueOf(true), new String[0]);
        return menu;
    }

    private String getUrl(OrgAccount account, String templateUrl) {
        return templateUrl.replaceAll("#ORG_NUM#", String.valueOf(account.getNumber()));
    }

    private String getSearchUrl(OrgInfo orgInfo, String templateUrl) {
        String url = templateUrl.replaceAll("#ORG_SHORTNAME#", orgInfo.getShortName());
        String domain = "";
        City city = (City)this.cityDao.getById((Serializable)orgInfo.getAreaId(), new String[0]);
        if (city != null && StringUtils.isNotBlank((CharSequence)city.getDomain())) {
            domain = String.valueOf(city.getDomain()) + ".";
        }
        url = url.replaceAll("#ORG_CITY#", domain);
        return url;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tempConvert(Integer orgId) {
        ArrayList<Integer> orgIds = this.orgWechatMenuDao.distinctOrgId();
        if (orgId != null) {
            orgIds = new ArrayList<Integer>();
            orgIds.add(orgId);
        }
        Map map = null;
        for (Integer id : orgIds) {
            map = this.orgWechatMenuDao.mapKeyNameValueUrl(id);
            JSONObject json = new JSONObject();
            JSONArray list = new JSONArray();
            JSONObject btn1 = new JSONObject();
            JSONArray subBtnList1 = new JSONArray();
            btn1.put((Object)"name", (Object)"\u673a\u6784\u8bfe\u7a0b");
            JSONObject subBtn11 = new JSONObject();
            subBtn11.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn11.put((Object)"name", (Object)"\u5168\u90e8\u8bfe\u7a0b");
            subBtn11.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u5168\u90e8\u8bfe\u7a0b")));
            subBtn11.put((Object)"url", map.get("\u5168\u90e8\u8bfe\u7a0b"));
            subBtnList1.add((Object)subBtn11);
            JSONObject subBtn12 = new JSONObject();
            subBtn12.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn12.put((Object)"name", (Object)"\u641c\u7d22\u8bfe\u7a0b");
            subBtn12.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u641c\u7d22\u8bfe\u7a0b")));
            subBtn12.put((Object)"url", map.get("\u641c\u7d22\u8bfe\u7a0b"));
            subBtnList1.add((Object)subBtn12);
            btn1.put((Object)"subButton", (Object)subBtnList1);
            JSONObject btn2 = new JSONObject();
            JSONArray subBtnList2 = new JSONArray();
            btn2.put((Object)"name", (Object)"\u673a\u6784\u4fe1\u606f");
            JSONObject subBtn21 = new JSONObject();
            subBtn21.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn21.put((Object)"name", (Object)"\u673a\u6784\u8001\u5e08");
            subBtn21.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u673a\u6784\u8001\u5e08")));
            subBtn21.put((Object)"url", map.get("\u673a\u6784\u8001\u5e08"));
            subBtnList2.add((Object)subBtn21);
            JSONObject subBtn22 = new JSONObject();
            subBtn22.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn22.put((Object)"name", (Object)"\u673a\u6784\u7b80\u4ecb");
            subBtn22.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u673a\u6784\u7b80\u4ecb")));
            subBtn22.put((Object)"url", map.get("\u673a\u6784\u7b80\u4ecb"));
            subBtnList2.add((Object)subBtn22);
            JSONObject subBtn23 = new JSONObject();
            subBtn23.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn23.put((Object)"name", (Object)"\u673a\u6784\u76f8\u518c");
            subBtn23.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u673a\u6784\u76f8\u518c")));
            subBtn23.put((Object)"url", map.get("\u673a\u6784\u76f8\u518c"));
            subBtnList2.add((Object)subBtn23);
            JSONObject subBtn24 = new JSONObject();
            subBtn24.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn24.put((Object)"name", (Object)"\u6821\u533a\u5730\u5740");
            subBtn24.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u6821\u533a\u5730\u5740")));
            subBtn24.put((Object)"url", map.get("\u6821\u533a\u5730\u5740"));
            subBtnList2.add((Object)subBtn24);
            btn2.put((Object)"subButton", (Object)subBtnList2);
            JSONObject btn3 = new JSONObject();
            JSONArray subBtnList3 = new JSONArray();
            btn3.put((Object)"name", (Object)"\u5728\u7ebf\u670d\u52a1");
            JSONObject subBtn31 = new JSONObject();
            subBtn31.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
            subBtn31.put((Object)"name", (Object)"\u673a\u6784\u4e3b\u9875");
            subBtn31.put((Object)"note", (Object)("[\u81ea\u5b9a\u4e49\u94fe\u63a5]" + (String)map.get("\u673a\u6784\u4e3b\u9875")));
            subBtn31.put((Object)"url", map.get("\u673a\u6784\u4e3b\u9875"));
            subBtnList3.add((Object)subBtn31);
            btn3.put((Object)"subButton", (Object)subBtnList3);
            list.add((Object)btn1);
            list.add((Object)btn2);
            list.add((Object)btn3);
            json.put((Object)"list", (Object)list);
            String jsonStr = json.toString();
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(id);
            Date now = new Date();
            if (authorizerInfo == null) continue;
            OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            if (menu == null) {
                menu = new OrgWechatCustomMenu();
                menu.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                menu.setCreateTime(now);
                menu.setUpdateTime(now);
                menu.setJson(jsonStr);
                try {
                    this.orgWechatCustomMenuDao.save((Object)menu, Boolean.valueOf(true), new String[0]);
                }
                catch (Exception e) {
                    log.error("menu convert ", (Throwable)e);
                }
                continue;
            }
            menu.setUpdateTime(now);
            menu.setJson(jsonStr);
            this.orgWechatCustomMenuDao.update((Object)menu, Boolean.valueOf(true), new String[0]);
        }
    }
}

