/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.WebResponseHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.beust.jcommander.internal.Maps;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessagePushServiceImpl
implements MessagePushService {
    private static final Logger log = LoggerFactory.getLogger(MessagePushServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private WechatMsgRenderService wechatMsgRenderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WebResponse<?> handle(MessageDto message) {
        block17: {
            log.info("handle - message from app to wechat - message:{}", (Object)message);
            try {
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(message.getOrgId());
                try {
                    if (message.getMsgT().intValue() == MsgType.TEXT.getValue()) {
                        this.handleTextMessage(authorizationInfo, message);
                        break block17;
                    }
                    if (message.getMsgT().intValue() == MsgType.PICTURE.getValue()) {
                        this.handleImageMessage(authorizationInfo, message);
                        break block17;
                    }
                    if (message.getMsgT().intValue() == MsgType.VOICE.getValue()) {
                        this.handleVoiceMessage(authorizationInfo, message);
                        break block17;
                    }
                    return WebResponseHelper.error((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_NONSUUPORT_TYPE);
                }
                catch (WechatException e) {
                    if (e.getErrorCode().getSubsystemErrorCode() == SalWechatErrorCode.WECHAT_CANNOT_SENDMSG_TO_FANS.getSubsystemErrorCode()) {
                        boolean sendTry = false;
                        try {
                            Map params = Maps.newHashMap();
                            params.put("first", "\u673a\u6784\u8bf7\u6c42\u4e0e\u60a8\u8fdb\u884c\u6c9f\u901a\uff0c\u82e5\u540c\u610f\u8bf7\u5728\u516c\u4f17\u53f7\u56de\u590d\u4efb\u610f\u6587\u5b57\u3002\n");
                            params.put("remark", "");
                            params.put("keyword1", "\u6c9f\u901a\u8bf7\u6c42");
                            params.put("keyword2", "" + message.getMsgId());
                            if (message.getMsgT().intValue() == MsgType.TEXT.getValue()) {
                                params.put("keyword3", message.getContent().getText());
                            } else if (message.getMsgT().intValue() == MsgType.PICTURE.getValue()) {
                                params.put("keyword3", "[\u56fe\u7247]");
                            } else if (message.getMsgT().intValue() == MsgType.VOICE.getValue()) {
                                params.put("keyword3", "[\u8bed\u97f3]");
                            }
                            params.put("touser", message.getWechatOpenId());
                            params.put("url", null);
                            Object msg = this.wechatMsgRenderService.render(Integer.valueOf(WechateTemplateMsgType.BATCH.getValue()), params);
                            this.wechatMsgRenderService.sendMsg(msg);
                            sendTry = true;
                        }
                        catch (Exception e2) {
                            log.warn("WECHAT_SEND_MESSAGE_FAIL_BUT_TRY - fail", (Throwable)e);
                            throw e;
                        }
                        if (sendTry) {
                            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL_BUT_TRY);
                        }
                        break block17;
                    }
                    throw e;
                }
            }
            catch (BussinessException | WebServiceException | WechatException e) {
                log.warn("handle - message from app to wechat - CustomException - message:{},e", (Object)message, (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("handle - message from app to wechat - Exception - message:{}", (Object)message);
                log.error("handle - message from app to wechat - Exception - e", (Throwable)e);
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_FAIL);
            }
        }
        return WebResponseHelper.success();
    }

    void handleTextMessage(AuthorizationInfo authorizationInfo, MessageDto message) {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        CustomerServiceApiHelper.sendTextMsg(accessToken, openId, content.getText() != null ? content.getText() : "null");
    }

    void handleImageMessage(AuthorizationInfo authorizationInfo, MessageDto message) throws Exception {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        File localFile = null;
        try {
            OrgStorage orgStorage = this.orgStorageDao.getById(content.getStorageId().intValue());
            byte[] data = HttpClientUtils.download((String)StorageUtil.constructUrl(orgStorage));
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.getMimeType((Integer)orgStorage.getMimeType()));
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.IMAGE, localFile);
            CustomerServiceApiHelper.sendImageMsg(accessToken, openId, mediaApiDto.getMediaId());
        }
        catch (Throwable throwable) {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
            throw throwable;
        }
        if (localFile != null) {
            LocalFileHelper.deleteFile(localFile);
        }
    }

    void handleVoiceMessage(AuthorizationInfo authorizationInfo, MessageDto message) throws Exception {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        File localFile = null;
        try {
            OrgStorage orgStorage = this.orgStorageDao.getById(content.getStorageId().intValue());
            byte[] data = HttpClientUtils.download((String)StorageUtil.constructUrl(orgStorage));
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.getMimeType((Integer)orgStorage.getMimeType()));
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.VOICE, localFile);
            CustomerServiceApiHelper.sendVoiceMsg(accessToken, openId, mediaApiDto.getMediaId());
        }
        catch (Throwable throwable) {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
            throw throwable;
        }
        if (localFile != null) {
            LocalFileHelper.deleteFile(localFile);
        }
    }
}

