/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMenu;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.MenuBuildService;
import com.baijia.tianxiao.sal.wechat.api.OrgWechatMenuService;
import com.baijia.tianxiao.sal.wechat.dto.menu.MenuBuildResult;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuApiCaller;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuBuildImpl
implements MenuBuildService {
    private static final Logger logger = LoggerFactory.getLogger(MenuBuildImpl.class);
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgPhotoDao orgImgsDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrgWechatMenuService orgWechatMenuService;

    @Override
    public MenuBuildResult autoBuild(Integer orgId) {
        MenuBuildResult result = this.checkOrgInfo(orgId);
        if (!(result.isValid() && result.isHasBranches() && result.isHasBrief() && result.isHasPhoto() && result.isHasVerified())) {
            logger.info("wechat - auto build failed - incomplete organization info - result:{}", (Object)result);
            return result;
        }
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        if (authorizationInfo == null) {
            logger.info("wechat - auto build failed - incomplete organization info - result:{}", (Object)result);
            result.setHasBind(false);
            return result;
        }
        this.orgWechatMenuService.deleteByOrgId(orgId);
        this.orgWechatMenuService.createDefaultMenu(orgId);
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        WechatMenuApiCaller.deleteMenu(accessToken);
        Map<String, Object> wechatMenu = this.buildWechatMenuFromOrgMenu(orgId);
        WechatApiResponse response = WechatMenuApiCaller.createMenu(accessToken, wechatMenu);
        if (response.isError()) {
            throw new WebServiceException("create wechat menu exception, orgId:" + orgId);
        }
        return result;
    }

    private Map<String, Object> buildWechatMenuFromOrgMenu(Integer orgId) {
        List<OrgWechatMenu> orgMenuList = this.orgWechatMenuService.getByOrgId(orgId);
        return this.buildWechatMenu(orgMenuList);
    }

    private Map<String, Object> buildWechatMenu(List<OrgWechatMenu> orgMenuList) {
        TreeMap menuStruct = Maps.newTreeMap();
        HashMap menuMap = Maps.newHashMap();
        for (OrgWechatMenu menu : orgMenuList) {
            menuMap.put(menu.getId(), menu);
            if (menu.getLevel() == 1) {
                menuStruct.put(menu.getId(), new ArrayList());
                continue;
            }
            List subMenuIdList = (List)menuStruct.get(menu.getPid());
            if (subMenuIdList == null) {
                logger.warn("wechat - build wechat menu - submenu has no parent:{}", (Object)menu);
                continue;
            }
            subMenuIdList.add(menu.getId());
        }
        ArrayList menuList = Lists.newArrayList();
        for (Map.Entry entry : menuStruct.entrySet()) {
            Integer topMenuId = (Integer)entry.getKey();
            List subMenuIdList = (List)entry.getValue();
            menuList.add(this.buildWechatMenu(menuMap, topMenuId, subMenuIdList));
        }
        HashMap result = Maps.newHashMap();
        result.put("button", menuList);
        return result;
    }

    private Map<String, Object> buildWechatMenu(Map<Integer, OrgWechatMenu> menuMap, Integer topMenuId, List<Integer> subMenuIdList) {
        HashMap result = Maps.newHashMap();
        OrgWechatMenu topMenu = menuMap.get(topMenuId);
        result.put("name", topMenu.getName());
        ArrayList subMenuList = Lists.newArrayList();
        for (Integer subMenuId : subMenuIdList) {
            OrgWechatMenu subMenu = menuMap.get(subMenuId);
            HashMap subMenuMap = Maps.newHashMap();
            subMenuMap.put("type", "view");
            subMenuMap.put("name", subMenu.getName());
            subMenuMap.put("url", subMenu.getUrl());
            subMenuList.add(subMenuMap);
        }
        if (subMenuList.size() > 0) {
            result.put("sub_button", subMenuList);
        }
        return result;
    }

    @Override
    public MenuBuildResult checkMenuInfo(Integer orgId) {
        MenuBuildResult result = this.checkOrgInfo(orgId);
        return result;
    }

    private MenuBuildResult checkOrgInfo(Integer orgId) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(orgId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgTxtMsg brief = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), 3301);
        List orgImgs = this.orgImgsDao.getByOrgIdAndCategory(orgId.intValue(), 2);
        List orgBranches = this.orgBranchsDao.listBranchsByOrgId(orgId.intValue());
        List<OrgWechatMenu> menus = this.orgWechatMenuService.getByOrgId(orgId);
        MenuBuildResult result = new MenuBuildResult();
        result.setValid(orgInfo.isPassAudit());
        result.setHasBrief(brief != null);
        result.setHasPhoto(orgImgs.size() > 0);
        result.setHasBranches(orgBranches.size() > 0);
        result.setHasMenu(menus.size() > 0);
        if (authorizerInfo != null) {
            result.setHasVerified((authorizerInfo = this.authorizerInfoService.syncAuthorizerInfo(authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId())).getVerifyType() >= 0 || authorizerInfo.getServiceType() == 2);
        } else {
            result.setHasVerified(false);
        }
        return result;
    }
}

