/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityWechatReplaceDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.ActivityWechatReplace;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.AutoReplyService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomActivityServiceImpl
implements CustomActivityService {
    private static final Logger log = LoggerFactory.getLogger(CustomActivityServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AutoReplyService autoReplyService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private ActivityWechatReplaceDao activityWechatReplaceDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomActivityDto createCustomActivity(int orgId, int activityId, int activityType, String title, String description, String picUrl) throws Exception {
        String qrCodeImgUrl;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForCustomActivity(authorizationInfo.getAuthorizerAccessToken(), activityId, activityType);
        File localFile = null;
        try {
            try {
                byte[] data = WechatQRCodeLinkHelper.downloadQRCodeImage(qrCodeDto.getTicket());
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                UploadResult result = FileUploadUtils.uploadToRemote(Long.parseLong(String.valueOf(orgId)), localFile, false);
                qrCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
            }
            catch (Exception e) {
                log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
            throw throwable;
        }
        if (localFile != null) {
            LocalFileHelper.deleteFile(localFile);
        }
        OrgWechatCustomActivity customActivity = new OrgWechatCustomActivity();
        customActivity.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        customActivity.setActivityType(Integer.valueOf(activityType));
        customActivity.setActivityId(Integer.valueOf(activityId));
        customActivity.setQrCodeUrl(qrCodeImgUrl);
        customActivity.setTitle(title);
        customActivity.setDescription(description);
        customActivity.setPicUrl(picUrl);
        customActivity.setCreateTime(new Date());
        try {
            this.customActivityDao.save((Object)customActivity, Boolean.valueOf(true), new String[0]);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", (Object)customActivity);
        }
        catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", (Object)customActivity);
            throw e;
        }
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        dto.setQrCodeUrl(qrCodeImgUrl);
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizationInfo.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CustomActivityDto getCustomActivity(int activityId, int activityType) {
        OrgWechatCustomActivity customActivity = this.customActivityDao.get(activityId, activityType);
        log.info("OrgWechatCustomActivity is : {} ", (Object)customActivity);
        if (customActivity == null) {
            return null;
        }
        Integer replaceId = customActivity.getReplaceOrgId();
        String qrCodeUrl = customActivity.getQrCodeUrl();
        if (replaceId != null && replaceId != -1) {
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(customActivity.getOriginOrgId());
            if (authorizerInfo == null) {
                return null;
            }
            Integer qrcodeStorageId = authorizerInfo.getQrcodeStorageId();
            qrCodeUrl = this.retrievalImgUrl(qrcodeStorageId);
        }
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setQrCodeUrl(qrCodeUrl);
        dto.setKeyWord(customActivity.getKeyWrod());
        dto.setReplaceOrgId(customActivity.getReplaceOrgId());
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, customActivity.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    private String retrievalImgUrl(Integer qrcodeStorageId) {
        OrgStorage orgStorage = this.orgStorageDao.getById(qrcodeStorageId.intValue());
        if (orgStorage == null) {
            log.info("can not retrieval authorizerInfo's qrCodeUrl {} ", (Object)qrcodeStorageId);
            return null;
        }
        return StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteCustomActivity(int activityId, int activityType) {
        this.customActivityDao.deleteBy(activityId, activityType);
    }

    @Override
    public CustomActivityDto createCustomActivityForReplace(int replaceOrgId, int originOrgId, int activityId, int templateId, String title, String description, String picUrl) throws Exception {
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(originOrgId);
        if (authorizerInfo == null) {
            return null;
        }
        boolean needReplace = false;
        int orgId = originOrgId;
        if (!authorizerInfo.isServiceApp() || !authorizerInfo.isPassedVerify()) {
            orgId = replaceOrgId;
            needReplace = true;
            log.info(" not have enought permission ,and will replace with : {} ", (Object)replaceOrgId);
        }
        boolean passedVerify = authorizerInfo.isPassedVerify();
        Integer serviceType = authorizerInfo.getServiceType();
        boolean isSubscribeAccoutn = false;
        if (serviceType != null && (serviceType == 0 || serviceType == 1)) {
            isSubscribeAccoutn = true;
        }
        boolean needFilterSubscribe = !passedVerify || !isSubscribeAccoutn;
        CustomActivityDto createCustomActivity = this.createCustomActivity(orgId, activityId, templateId, title, description, picUrl);
        OrgWechatCustomActivity customActivity = this.customActivityDao.get(activityId, templateId);
        if (needReplace) {
            String keywordFormat = "[{'keyword':'%s','isExactMatch':1}]";
            String keyWord = this.createKeyWord(activityId, templateId);
            keyWord = String.format(keywordFormat, keyWord);
            log.info("keyword is : {} ", (Object)keyWord);
            MediaType mediaType = MediaType.ZIDINGYILIANJIE;
            customActivity.setKeyWrod(keyWord);
            String url = createCustomActivity.getWebAuthUrl();
            url = ShortUrlUtil.getShortUrl((String)url);
            OrgWechatReplyForKeyword saveOrUpdateKeywordReply = this.autoReplyService.saveOrUpdateKeywordReply(originOrgId, null, keyWord, mediaType.getValue(), null, url, null, "");
            log.info("create autoReply obj is : {} ", (Object)saveOrUpdateKeywordReply);
            customActivity.setReplaceOrgId(Integer.valueOf(replaceOrgId));
            customActivity.setOriginOrgId(Integer.valueOf(originOrgId));
            this.saveReplaceInfo(originOrgId, replaceOrgId, needFilterSubscribe);
        }
        customActivity.setAuthorizerAppId(createCustomActivity.getAuthorizerAppId());
        customActivity.setQrCodeUrl(createCustomActivity.getQrCodeUrl());
        log.info("customActivity obj is : {} ", (Object)customActivity);
        try {
            this.customActivityDao.saveOrUpdate((Object)customActivity, new String[0]);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", (Object)customActivity);
        }
        catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", (Object)customActivity);
            throw e;
        }
        return createCustomActivity;
    }

    private static String addParam(String url) {
        log.info("url is : {} ", (Object)url);
        String find = "landingPage%3D";
        int indexOf = url.indexOf(find);
        int paramPathIndexOf = url.indexOf("%253F", indexOf);
        String preStr = url.substring(0, paramPathIndexOf);
        String nextStr = url.substring(paramPathIndexOf + 1);
        String retUrl = String.valueOf(preStr) + "%253FreplyFrom=wechatBackgroud%2526" + nextStr;
        return retUrl;
    }

    private void saveReplaceInfo(int originOrgId, int replaceOrgId, boolean needFilterSubscribe) {
        try {
            ActivityWechatReplace replace = new ActivityWechatReplace();
            replace.setOriginOrgId(Integer.valueOf(originOrgId));
            replace.setReplaceOrgId(Integer.valueOf(replaceOrgId));
            replace.setNeedFilterSubscribe(needFilterSubscribe ? 0 : 1);
            this.activityWechatReplaceDao.save((Object)replace, new String[0]);
        }
        catch (DuplicateKeyException e) {
            log.info("has alerdy insert {} ", (Object)(String.valueOf(originOrgId) + "_" + replaceOrgId));
        }
    }

    private String createContent(int activityId, int activityType) {
        StringBuilder visitUrl = new StringBuilder();
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        visitUrl.append(WechatProperties.getWebMarketingUrlPrefix());
        visitUrl.append(relativePath);
        visitUrl.append("&activityId=").append(activityId);
        visitUrl.append("&activityType=").append(activityType);
        return visitUrl.toString();
    }

    private String createKeyWord(int activityId, int activityType) {
        String desc = this.createDescOfActivity(activityType);
        return String.valueOf(desc) + activityId;
    }

    private String createDescOfActivity(Integer templateId) {
        Template selectTemplateById = this.templateDao.selectTemplateById(templateId);
        Integer activityType = -1;
        if (selectTemplateById != null) {
            activityType = selectTemplateById.getTypeId();
        }
        switch (activityType) {
            case 3: {
                return "\u5fae\u6d3b\u52a8";
            }
            case 99: {
                return "\u62bd\u5956";
            }
            case 201: {
                return "\u6295\u7968";
            }
            case 301: {
                return "\u8f6c\u4ecb\u7ecd";
            }
        }
        return "\u8425\u9500";
    }
}

