/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorizerInfoServiceImpl
implements AuthorizerInfoService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizerInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(AuthorizerInfoServiceImpl.class);
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(AuthorizerInfo authorizerInfo) {
        this.authorizerInfoDao.update((Object)authorizerInfo, Boolean.valueOf(true), new String[0]);
        log.info("wechat - AuthorizerInfoServiceImpl - update authorizerInfo:{}", (Object)authorizerInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetOngoing() {
        log.info("wechat - AuthorizerInfoServiceImpl - resetOngoing");
        this.authorizerInfoDao.resetOngoingStatus();
    }

    @Override
    @Transactional(readOnly=true)
    public AuthorizerInfo getByOrgId(Integer orgId) {
        return this.authorizerInfoDao.getByOrgId(orgId);
    }

    @Override
    @Transactional(readOnly=true)
    public AuthorizerInfo getByUserName(String userName) {
        return this.authorizerInfoDao.getByUserName(userName);
    }

    @Override
    @Transactional(readOnly=true)
    public AuthorizerInfo getByAuthorizerAppId(String authorizerAppId) {
        return this.authorizerInfoDao.getByAuthorizerAppId(authorizerAppId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AuthorizerInfo syncAuthorizerInfo(Integer orgId, String authorizerAppId) {
        logger.info("wechat - sync authorizer info - orgId:{}, authorizerAppId:{}", (Object)orgId, (Object)authorizerAppId);
        OpenPlatformInfoDto openPlatformInfo = WechatProperties.getOpenPlatformInfo();
        String componentAccessToken = this.componentAccessTokenDao.getByAppId(openPlatformInfo.getAppId()).getComponentAccessToken();
        AuthorizerInfo newAuthorizerInfo = OpenPlatApiHelper.requestAuthorizerInfo(openPlatformInfo.getAppId(), componentAccessToken, authorizerAppId);
        newAuthorizerInfo.setAuthorizerAppId(authorizerAppId);
        newAuthorizerInfo.setOrgId(orgId);
        Date now = new Date();
        AuthorizerInfo info = this.authorizerInfoDao.getByOrgId(orgId);
        if (info == null) {
            info = newAuthorizerInfo;
            info.setQrcodeStorageId(this.uploadQrcode(newAuthorizerInfo.getOrgId(), newAuthorizerInfo.getQrcodeUrl()));
            info.setUpdateTime(now);
            info.setCreateTime(now);
            info.setFansSyncStatus(Integer.valueOf(WechatDataSyncStatus.NOTSTART.getValue()));
            info.setMediaNewsSyncStatus(Integer.valueOf(WechatDataSyncStatus.NOTSTART.getValue()));
            this.authorizerInfoDao.save((Object)info, Boolean.valueOf(true), new String[0]);
            logger.info("wechat - add new authorizer info - info:{}", (Object)info);
            return info;
        }
        info.setAuthorizerAppId(newAuthorizerInfo.getAuthorizerAppId());
        info.setOrgId(newAuthorizerInfo.getOrgId());
        info.setAlias(newAuthorizerInfo.getAlias());
        info.setNickName(newAuthorizerInfo.getNickName());
        info.setUserName(newAuthorizerInfo.getUserName());
        info.setHeadImg(newAuthorizerInfo.getHeadImg());
        info.setQrcodeUrl(newAuthorizerInfo.getQrcodeUrl());
        info.setQrcodeStorageId(this.uploadQrcode(orgId, info.getQrcodeUrl()));
        info.setServiceType(newAuthorizerInfo.getServiceType());
        info.setVerifyType(newAuthorizerInfo.getVerifyType());
        info.setUpdateTime(now);
        this.authorizerInfoDao.update((Object)info, Boolean.valueOf(true), new String[0]);
        logger.info("wechat - update authorizer info - info:{}", (Object)info);
        return info;
    }

    private Integer uploadQrcode(Integer orgId, String url) {
        Integer n;
        block9: {
            byte[] data;
            Long uid;
            File localFile;
            long start;
            block7: {
                Integer n2;
                block8: {
                    if (StringUtils.isBlank((CharSequence)url)) {
                        logger.warn("wechat - upload qrcode - url is null - orgId:{}", (Object)orgId);
                        return 0;
                    }
                    start = System.currentTimeMillis();
                    localFile = null;
                    uid = Long.parseLong("" + orgId);
                    data = HttpClientUtils.download((String)url);
                    if (data != null) break block7;
                    logger.warn("wechat - upload qrcode - download failed - orgId:{}, url:{}", (Object)orgId, (Object)url);
                    n2 = 0;
                    if (localFile == null) break block8;
                    LocalFileHelper.deleteFile(localFile);
                }
                return n2;
            }
            try {
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPEG);
                UploadResult result = FileUploadUtils.uploadToRemote(uid, localFile, false);
                long end = System.currentTimeMillis();
                logger.info("UploadService.upload: uid:{}, file.len:{}, cost:{}", new Object[]{uid, data.length, end - start});
                n = this.saveToDb(result);
                if (localFile == null) break block9;
            }
            catch (Exception e) {
                Integer n3;
                block10: {
                    try {
                        logger.error("wechat - upload qrcode exception - ", (Throwable)e);
                        n3 = 0;
                        if (localFile == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (localFile != null) {
                            LocalFileHelper.deleteFile(localFile);
                        }
                        throw throwable;
                    }
                    LocalFileHelper.deleteFile(localFile);
                }
                return n3;
            }
            LocalFileHelper.deleteFile(localFile);
        }
        return n;
    }

    private Integer saveToDb(UploadResult uploadResult) {
        List uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return 0;
        }
        UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(MIMEType.JPEG.getCode()));
        orgStorage.setSource(Short.valueOf((short)0));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }
}

