/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.openplat;

import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.xml.ws.WebServiceException;

public class OpenPlatApiCaller {
    public static WechatApiResponse requestComponentAccessToken(String componentAppId, String componentAppSecret, String componentVerifyTicket) throws WechatException, WebServiceException {
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_component_token";
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("component_appsecret", componentAppSecret);
        params.put("component_verify_ticket", componentVerifyTicket);
        return WechatRemoteCallHelper.postJson(url, params);
    }

    public static WechatApiResponse requestPreAuthCode(String componentAppId, String componentAccessToken) throws WechatException, WebServiceException {
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode?component_access_token=" + componentAccessToken;
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        return WechatRemoteCallHelper.postJson(url, params);
    }

    public static WechatApiResponse requestAuthorizationInfo(String componentAppId, String componentAccessToken, String authCode) throws WechatException, WebServiceException {
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_query_auth?component_access_token=" + componentAccessToken;
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorization_code", authCode);
        return WechatRemoteCallHelper.postJson(url, params);
    }

    public static WechatApiResponse requestAuthorizerInfo(String componentAppId, String componentAccessToken, String authorizerAppId) throws WechatException, WebServiceException {
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info?component_access_token=" + componentAccessToken;
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorizer_appid", authorizerAppId);
        return WechatRemoteCallHelper.postJson(url, params);
    }

    public static WechatApiResponse requestAuthorizerAccessToken(String componentAppId, String componentAccessToken, String authorizerAppId, String authorizerRefreshToken) throws WechatException, WebServiceException {
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token?component_access_token=" + componentAccessToken;
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorizer_appid", authorizerAppId);
        params.put("authorizer_refresh_token", authorizerRefreshToken);
        return WechatRemoteCallHelper.postJson(url, params);
    }
}

