/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.custommenu;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CustomMenuBtn {
    private MediaType type;
    private String name;
    private String url;
    private String content;
    private String note;
    private String mediaId;
    private String key;
    private List<CustomMenuBtn> subButton;

    public static CustomMenuBtn buildViewBtn(MediaType type, OrgWechatDto orgWechatDto) {
        CustomMenuBtn btn = new CustomMenuBtn();
        btn.setName(type.getLabel());
        btn.setType(type);
        btn.setUrl(type.getUrl(orgWechatDto));
        btn.setNote(type.getNote());
        return btn;
    }

    public static CustomMenuBtn buildHierarchyBtn(MediaType type, OrgWechatDto orgWechatDto, List<CustomMenuBtn> subButton) {
        CustomMenuBtn btn = new CustomMenuBtn();
        btn.setName(type.getLabel());
        btn.setNote(type.getNote());
        btn.setSubButton(subButton);
        return btn;
    }

    public static CustomMenuBtn buildTextBtn(MediaType type, String content, OrgWechatDto orgWechatDto) {
        CustomMenuBtn btn = new CustomMenuBtn();
        btn.setName(type.getLabel());
        btn.setType(type);
        btn.setContent(content);
        btn.setNote(String.valueOf(type.getNote()) + content);
        return btn;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        if (this.type != null) {
            json.put((Object)"mediaType", (Object)this.type.getValue());
        }
        json.put((Object)"name", (Object)this.name);
        json.put((Object)"mediaId", (Object)this.mediaId);
        json.put((Object)"note", (Object)this.note);
        json.put((Object)"content", (Object)this.content);
        json.put((Object)"url", (Object)this.url);
        if (this.subButton != null && !this.subButton.isEmpty()) {
            JSONArray subBtnArray = new JSONArray();
            for (CustomMenuBtn btn : this.subButton) {
                subBtnArray.add((Object)btn.toJson());
            }
            json.put((Object)"subButton", (Object)subBtnArray);
        }
        return json;
    }

    public String toJsonStr() {
        return this.toJson().toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public MediaType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContent() {
        return this.content;
    }

    public String getNote() {
        return this.note;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getKey() {
        return this.key;
    }

    public List<CustomMenuBtn> getSubButton() {
        return this.subButton;
    }

    public void setType(MediaType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSubButton(List<CustomMenuBtn> subButton) {
        this.subButton = subButton;
    }
}

