/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.ComponentVerifyTicketDao;
import com.baijia.tianxiao.dal.wechat.po.ComponentVerifyTicket;
import com.baijia.tianxiao.sal.wechat.api.ComponentVerifyTicketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComponentVerifyTicketServiceImpl
implements ComponentVerifyTicketService {
    private static final Logger logger = LoggerFactory.getLogger(ComponentVerifyTicketServiceImpl.class);
    @Autowired
    private ComponentVerifyTicketDao componentVerifyTicketDao;

    @Override
    @Transactional(readOnly=true)
    public ComponentVerifyTicket getByAppId(String appId) {
        return this.componentVerifyTicketDao.getByAppId(appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(ComponentVerifyTicket newTicket) {
        ComponentVerifyTicket ticket = this.getByAppId(newTicket.getAppId());
        if (ticket == null) {
            this.componentVerifyTicketDao.save((Object)newTicket, Boolean.valueOf(true), new String[0]);
            logger.info("wechat - add new component verify ticket:{}", (Object)newTicket);
            return;
        }
        ticket.setComponentVerifyTicket(newTicket.getComponentVerifyTicket());
        ticket.setCreateTime(newTicket.getCreateTime());
        ticket.setInfoType(newTicket.getInfoType());
        this.componentVerifyTicketDao.update((Object)ticket, Boolean.valueOf(true), new String[0]);
        logger.info("wechat - update component verify ticket:{}", (Object)ticket);
    }
}

