/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.SubscribeQRCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.image.OrgQrImageUtils;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.SubscribeQRCodeService;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubscribeQRCodeServiceImpl
implements SubscribeQRCodeService {
    private static final Logger log = LoggerFactory.getLogger(SubscribeQRCodeServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private SubscribeQRCodeDao subscribeQRCodeDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getQRCodeUrl(Integer orgId) {
        String string;
        File localFileB;
        block13: {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
            if (authorizerInfo == null) {
                log.warn("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - authorizationInfo is null");
                return null;
            }
            SubscribeQRCode qrCode = this.subscribeQRCodeDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            if (qrCode != null) {
                return qrCode.getHeadQrCode();
            }
            File localFileA = null;
            localFileB = null;
            String qrCodeImgUrl = null;
            try {
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
                UploadResult result = null;
                if (authorizerInfo.getQrcodeStorageId() != null) {
                    OrgStorage orgStorage = this.orgStorageDao.getById(authorizerInfo.getQrcodeStorageId().intValue());
                    qrCodeImgUrl = orgStorage == null ? authorizerInfo.getQrcodeUrl() : StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
                }
                if (StringUtils.isBlank(qrCodeImgUrl)) {
                    QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDto(authorizationInfo.getAuthorizerAccessToken());
                    byte[] data = WechatQRCodeLinkHelper.downloadQRCodeImage(qrCodeDto.getTicket());
                    localFileA = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                    result = FileUploadUtils.uploadToRemote(Long.parseLong(orgId + ""), localFileA, false);
                    qrCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
                }
                BufferedImage image = OrgQrImageUtils.generateOrgQrFingerPrintImg((String)orgInfo.getName(), qrCodeImgUrl, (String)orgInfo.getExtension(), (String)authorizerInfo.getNickName());
                localFileB = new File(LocalFileHelper.getTmpFileName(MIMEType.JPG.getExtension()));
                ImageIO.write((RenderedImage)image, MIMEType.JPG.getExtension(), localFileB);
                result = FileUploadUtils.uploadToRemote(Long.parseLong(orgId + ""), localFileB, false);
                String headQRCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
                qrCode = this.subscribeQRCodeDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                if (qrCode == null) {
                    qrCode = new SubscribeQRCode();
                    qrCode.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                    qrCode.setHeadQrCode(headQRCodeImgUrl);
                    qrCode.setQrCode(qrCodeImgUrl);
                    qrCode.setCreateTime(new Date());
                    this.subscribeQRCodeDao.save((Object)qrCode, new String[0]);
                }
                string = headQRCodeImgUrl;
                if (localFileA == null) break block13;
            }
            catch (Exception e) {
                log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - exception", (Throwable)e);
                String string2 = null;
                return string2;
            }
            finally {
                if (localFileA != null) {
                    LocalFileHelper.deleteFile(localFileA);
                }
                if (localFileB != null) {
                    LocalFileHelper.deleteFile(localFileB);
                }
            }
            LocalFileHelper.deleteFile(localFileA);
        }
        if (localFileB != null) {
            LocalFileHelper.deleteFile(localFileB);
        }
        return string;
    }
}

