/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.dao.PreAuthCodeDao;
import com.baijia.tianxiao.dal.wechat.po.PreAuthCode;
import com.baijia.tianxiao.sal.wechat.api.PreAuthCodeService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PreAuthCodeServiceImpl
implements PreAuthCodeService {
    private static final Logger logger = LoggerFactory.getLogger(PreAuthCodeServiceImpl.class);
    @Autowired
    private PreAuthCodeDao preAuthCodeDao;
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;

    @Override
    @Transactional(readOnly=true)
    public PreAuthCode get() {
        String appId = WechatProperties.getOpenAppId();
        return this.getByAppId(appId);
    }

    @Override
    @Transactional(readOnly=true)
    public PreAuthCode getByAppId(String appId) {
        return this.preAuthCodeDao.getByAppId(appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update() {
        String appId = WechatProperties.getOpenAppId();
        String componentAccessToken = this.componentAccessTokenDao.getByAppId(appId).getComponentAccessToken();
        PreAuthCode newPreAuthCode = OpenPlatApiHelper.requestPreAuthCode(appId, componentAccessToken);
        PreAuthCode preAuthCode = this.getByAppId(appId);
        if (preAuthCode == null) {
            this.preAuthCodeDao.save((Object)newPreAuthCode, Boolean.valueOf(true), new String[0]);
            logger.info("wechat - add new preauthcode:{}", (Object)newPreAuthCode);
            return;
        }
        preAuthCode.setUpdateTime(new Date());
        preAuthCode.setExpiresIn(newPreAuthCode.getExpiresIn());
        preAuthCode.setPreAuthCode(newPreAuthCode.getPreAuthCode());
        this.preAuthCodeDao.update((Object)preAuthCode, Boolean.valueOf(true), new String[0]);
        logger.info("wechat - update preauthcode:{}", (Object)preAuthCode);
    }
}

