/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.activity.dao.ActivityWechatFilterDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.emoticons.WechatEmoticons;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgType;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStr;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrActivity;
import com.baijia.tianxiao.sal.wechat.dto.request.MessageRequest;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSCANEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatImageMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatVoiceMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.AutoReplyHelper;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.KeyWordMatcher;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgHelper;
import com.baijia.tianxiao.sal.wechat.helper.common.MessageBuilder;
import com.baijia.tianxiao.sal.wechat.helper.common.WechatCryptUtils;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.AudioUtil;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageReceiveServiceImpl
implements MessageReceiveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiveServiceImpl.class);
    private static final String RELEASE_TEST_USERNAME = "gh_3c884a361561";
    @Autowired
    private ReleaseTest releaseTest;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgWechatReplyForKeywordDao replyForKeywordDao;
    @Autowired
    private OrgWechatReplyForSubscribeDao replySubscribeDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private ActivityWechatFilterDao activityWechatFilterDao;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private CloudQueue consultMsgQueue;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String generateDefaultResponse() {
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String handle(MessageRequest request) {
        log.info("handle - message from wechat to app - request:{}", (Object)request);
        String xmlMsg = WechatCryptUtils.decryptMsg(request.getMsgSignature(), request.getTimestamp(), request.getNonce(), request.getPostData());
        WechatAbstractMessage message = MessageBuilder.build(xmlMsg);
        log.info(" message is : {} ", (Object)message);
        if (message.getToUserName().equals(RELEASE_TEST_USERNAME)) {
            return this.releaseTest.handleTestMsg(message);
        }
        log.info("=======0======");
        if (message.getMsgType() == WechatMsgType.EVENT) {
            WechatEventMessage eventMessage = (WechatEventMessage)message;
            String msgKey = String.format("wechat.msg.%s.%s", eventMessage.getFromUserName(), eventMessage.getCreateTime());
            if (!this.isFirstTimeHandle(msgKey)) {
                return this.generateDefaultResponse();
            }
            if (this.fansPretreatment(eventMessage) == null) {
                return this.generateDefaultResponse();
            }
            return this.generateEventResponse(eventMessage);
        }
        try {
            log.info("\u666e\u901a\u6d88\u606f------");
            WechatOrdinaryMessage ordinaryMessage = (WechatOrdinaryMessage)message;
            String msgKey = String.format("wechat.msg.%s", ordinaryMessage.getMsgId());
            if (!this.isFirstTimeHandle(msgKey)) {
                return this.generateDefaultResponse();
            }
            log.info(" =====1===== ");
            boolean needFilter = this.activityWechatFilterDao.needFilter(ordinaryMessage.getToUserName());
            log.info("need filter : {} ", (Object)needFilter);
            if (!needFilter && this.fansPretreatment(ordinaryMessage) == null) {
                return this.generateDefaultResponse();
            }
            log.info(" =====2===== ");
            return this.generateOrdinaryResponse(ordinaryMessage);
        }
        catch (Exception e) {
            try {
                log.error("handle - generateOrdinaryResponse - exception", (Throwable)e);
                return this.generateDefaultResponse();
            }
            catch (Exception e2) {
                log.error("MessageReceiveServiceImpl - handle - exception", (Throwable)e2);
                return this.generateDefaultResponse();
            }
        }
    }

    private String generateEventResponse(WechatEventMessage message) {
        switch (message.getEvent()) {
            case SUBSCRIBE: {
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(subscribeMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (StringUtils.isNotBlank((CharSequence)subscribeMsg.getTicket())) {
                    String params = subscribeMsg.getEventKey();
                    QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                    if (qwCodeType != null) {
                        switch (qwCodeType) {
                            case CUSTOM_ACTIVITY: {
                                QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                                OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                                Template template = this.templateDao.selectTemplateById(dto.getActivityType());
                                String relativePath = template != null ? template.getUrl() : null;
                                String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType(), relativePath);
                                return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                            }
                        }
                    } else {
                        log.warn("wechat QRCodeType is null - params:{}", (Object)params);
                    }
                }
                OrgWechatReplyForSubscribe reply = this.replySubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId());
                String replyContent = PassiveReplyMsgHelper.getSubscribeReply(subscribeMsg.getToUserName(), subscribeMsg.getFromUserName(), reply);
                if (reply != null && !replyContent.equals("success")) {
                    AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                    try {
                        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                        AutoReplyHelper.sendSubscribeReply(authorizationInfo.getAuthorizerAccessToken(), subscribeMsg.getFromUserName(), reply);
                        break;
                    }
                    catch (Exception e) {
                        return replyContent;
                    }
                }
                return this.getDefaultSubscribeReply(subscribeMsg, authorizerInfo);
            }
            case UNSUBSCRIBE: {
                break;
            }
            case SCAN: {
                WechatSCANEventMessage scanMsg = (WechatSCANEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(scanMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (!StringUtils.isNotBlank((CharSequence)scanMsg.getTicket())) break;
                String params = scanMsg.getEventKey();
                QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                if (qwCodeType != null) {
                    switch (qwCodeType) {
                        case CUSTOM_ACTIVITY: {
                            QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                            OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                            Template template = this.templateDao.selectTemplateById(dto.getActivityType());
                            String relativePath = template != null ? template.getUrl() : null;
                            String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType(), relativePath);
                            return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                        }
                    }
                    break;
                }
                log.warn("wechat - unknow qwCodeType - params:{}", (Object)params);
                break;
            }
            case LOCATION: {
                break;
            }
            case MENU_CLICK: {
                AuthorizationInfo authorizationInfo;
                String content;
                Map<String, String> keyVsContentMap;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                if (menu == null || (keyVsContentMap = WechatMenuJsonConverter.mapClickKeyVsContent(menu.getJson())) == null || keyVsContentMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)(content = keyVsContentMap.get(message.getEventKey()))) || (authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId())) == null) break;
                CustomerServiceApiCaller.sendTextMsg(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), content);
                break;
            }
            case MENU_VIEW: {
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown event message - message:{}", (Object)message);
            }
        }
        return this.generateDefaultResponse();
    }

    String getDefaultSubscribeReply(WechatSubscribeEventMessage message, AuthorizerInfo authorizerInfo) {
        Integer orgId = authorizerInfo.getOrgId();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgWechatDto owDto = new OrgWechatDto(orgId, orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        StringBuilder content = new StringBuilder();
        content.append("\u81f4\u4eb2\u7231\u7684\u4f60\uff1a\n\n");
        content.append("\u6b22\u8fce\u52a0\u5165").append(orgInfo.getShortName()).append("\u5927\u5bb6\u5ead!").append("\n\n");
        content.append(this.getHrefLink(MediaType.WANGXIAOZHUYE.getUrl(owDto), orgInfo.getShortName() + "\u5fae\u5b98\u7f51\u6b63\u5f0f\u4e0a\u7ebf\u5566!\u8fdb\u6765\u770b\u770b\u6709\u60ca\u559c\u54e6!")).append("\n\n");
        content.append("\u73b0\u5728\u9884\u7ea6\u4f53\u9a8c\u8bfe\uff0c\u83b7\u8c6a\u534e\u5927\u793c\u5305\uff08\u4ec5\u9650\u9996\u6b21\u9884\u7ea6\u7528\u6237\uff09\uff0c\u8fd8\u5728\u7b49\u4ec0\u4e48\uff0c\u70b9\u51fb").append(this.getHrefLink(MediaType.YUYUESHITING.getUrl(owDto), "\u9884\u7ea6\u8bd5\u542c")).append("!").append("\n\n");
        content.append("\u54a8\u8be2\u8bfe\u7a0b\uff1f\u6b22\u8fce\u7559\u4e0b\u60a8\u7684\u59d3\u540d\u3001\u8054\u7cfb\u65b9\u5f0f\uff0c\u6211\u4eec\u4f1a\u6709\u4e13\u4e1a\u7684\u8001\u5e08\u5e2e\u60a8\u8be6\u7ec6\u89e3\u7b54\u3002").append("\n\n");
        if (authorizerInfo.hasWebAuthPermission()) {
            content.append("\u60f3\u5feb\u901f\u67e5\u8bfe\u8868\u3001\u5199\u8bc4\u4ef7\u3001\u770b\u4e0a\u8bfe\u8bb0\u5f55\uff1f\u4e0d\u8bba\u662f\u5b66\u751f\u8fd8\u662f\u8001\u5e08\uff0c\u53ef\u5728\u201c").append(this.getHrefLink(MediaType.XUESHENGZHONGXIN.getUrl(owDto), "\u5b66\u751f\u4e2d\u5fc3")).append("/").append(this.getHrefLink(MediaType.LAOSHIZHONGXIN.getUrl(owDto), "\u8001\u5e08\u4e2d\u5fc3")).append("\u201d\u8f7b\u677e\u5b8c\u6210\uff0c\u9a6c\u4e0a\u8fdb\u884c\u8eab\u4efd\u9a8c\u8bc1\u5427\u3002").append("\n\n");
        }
        if (authorizerInfo.getAuthorizerAppId().equals("wx21d5db9a0caa082d")) {
            content.append("\u6709\u8bdd\u5bf9\u6211\u4eec\u8bf4\uff1f\u6b22\u8fce\u6253\u7535\u8bdd\u7ed9\u6211\u4eec\u54df~ ").append("4006359779").append(" \uff0c\u6211\u4eec\u5c06\u6089\u5fc3\u8046\u542c\uff0c\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002").append("\n\n");
        } else {
            content.append("\u6709\u8bdd\u5bf9\u6211\u4eec\u8bf4\uff1f\u6b22\u8fce\u6253\u7535\u8bdd\u7ed9\u6211\u4eec\u54df~ ").append(WechatProperties.getMobileNumber400Main() + "\u8f6c" + orgInfo.getExtension()).append(" \uff0c\u6211\u4eec\u5c06\u6089\u5fc3\u8046\u542c\uff0c\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002").append("\n\n");
        }
        content.append("\u7cbe\u5f69\u6d3b\u52a8\uff0c\u656c\u8bf7\u5173\u6ce8\uff01").append("\n\n");
        return PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content.toString());
    }

    String getHrefLink(String href, String content) {
        String link = "<a href=\"%s\">%s</a>";
        return String.format(link, href, content);
    }

    void sendMenuVisitMonitor(AuthorizerInfo authorizerInfo, String openId) {
        if (authorizerInfo == null || StringUtils.isBlank((CharSequence)openId)) {
            return;
        }
        try {
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
            String url = WechatProperties.getWebCRMUrlPrefix() + "monitor.do";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgNumber", orgAccount.getNumber() + "");
            params.put("userNumber", openId);
            params.put("typeNumber", "10");
            HttpClientUtils.doGet((String)url, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String generateOrdinaryResponse(WechatOrdinaryMessage message) throws WechatException, WebServiceException, Exception {
        switch (message.getMsgType()) {
            case TEXT: {
                return this.generateTextOrdinaryResponse((WechatTextMessage)message);
            }
            case IMAGE: {
                return this.generateImageOrdinaryResponse((WechatImageMessage)message);
            }
            case VOICE: {
                return this.generateVoiceOrdinaryResponse((WechatVoiceMessage)message);
            }
            case VIDEO: {
                break;
            }
            case SHORT_VIDEO: {
                break;
            }
            case LOCATION: {
                break;
            }
            case LINK: {
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown type message - message:{}", (Object)message);
                break;
            }
        }
        return this.generateDefaultResponse();
    }

    private String generateTextOrdinaryResponse(WechatTextMessage message) {
        log.info("\u666e\u901a\u6d88\u606f-\u6587\u672c {} ", (Object)message);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (authorizerInfo == null) {
            return this.generateDefaultResponse();
        }
        if (!this.activityWechatFilterDao.needFilter(message.getToUserName())) {
            Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
            MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
            dto.setTextContent(WechatEmoticons.convert(message.getContent()));
            String msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJsonStr());
            try {
                this.consultMsgQueue.putMessage(new Message(msg));
                log.info("put message to consultMsgQueue msg:{}", (Object)msg);
            }
            catch (Exception e) {
                log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
            }
        }
        List replyList = this.replyForKeywordDao.search(authorizerInfo.getAuthorizerAppId(), null);
        log.info(" all ReplyList is : {}  ", (Object)replyList);
        OrgWechatReplyForKeyword reply = KeyWordMatcher.match(message.getContent(), replyList);
        log.info(" OrgWechatReplyForKeyword is : {}  ", (Object)reply);
        if (reply != null) {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            try {
                WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                AutoReplyHelper.sendKeywordReply(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), reply);
            }
            catch (Exception e) {
                return PassiveReplyMsgHelper.getKeywordReply(message.getToUserName(), message.getFromUserName(), reply);
            }
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateImageOrdinaryResponse(WechatImageMessage message) throws WechatException, WebServiceException, Exception {
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        if (authorizationInfo == null) {
            return this.generateDefaultResponse();
        }
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.JPG);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            image = ImageIO.read(localFile);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block9: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateImageOrdinaryResponse - exception");
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block9;
                }
                catch (Throwable var13_15) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var13_15;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        dto = new MessageDto(MsgType.PICTURE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setImageContent(storageId, StorageUtil.constructUrl(orgStorage), imageHeight, imageWidth);
        msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateVoiceOrdinaryResponse(WechatVoiceMessage message) throws WechatException, WebServiceException, Exception {
        if (StringUtils.isNotBlank((CharSequence)message.getRecognition())) {
            textMessage = new WechatTextMessage("[\u8bed\u97f3\u8bc6\u522b] " + message.getRecognition());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        if (!message.getFormat().toLowerCase().equals("amr")) {
            textMessage = new WechatTextMessage("[\u4e0d\u652f\u6301\u7684\u8bed\u97f3\u7c7b\u578b] " + message.getFormat().toLowerCase());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.AMR);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.AMR);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            voiceLength = Integer.parseInt(AudioUtil.getAmrDuration(localFile) + "");
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block10: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateVoiceOrdinaryResponse - exception", (Throwable)e);
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block10;
                }
                catch (Throwable var11_15) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var11_15;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        dto = new MessageDto(MsgType.VOICE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setVoiceContent(storageId, StorageUtil.constructUrl(orgStorage), voiceLength);
        msg = MessageSource.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    private String generateSubscribeEventResponse(WechatSubscribeEventMessage message) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(authorizerInfo.getOrgId(), new String[0]);
            OrgTxtMsg brief = this.orgTxtMsgDao.getOrgTxtByIdAndType(authorizerInfo.getOrgId().intValue(), 3101);
            StringBuilder msg = new StringBuilder();
            String intro = "";
            if (brief != null && StringUtils.isNotBlank((CharSequence)brief.getValue())) {
                intro = brief.getValue();
            }
            msg.append("\u611f\u8c22\u5173\u6ce8\u3010").append(orgInfo.getShortName()).append("\u3011\u3002").append(intro);
            String content = msg.toString();
            String response = WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            log.info("wechat - return subscribe event response:{}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private Integer saveToDb(UploadResult uploadResult, MIMEType mimeType) {
        List uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return 0;
        }
        UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(mimeType.getCode()));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStorage.setSource(Short.valueOf((short)0));
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstTimeHandle(String key) {
        log.info("Wechat - isFirstTimeHandle - check - key:{}", (Object)key);
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.exists(key.getBytes()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            connection.setEx(key.getBytes(), 20L, "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - isFirstTimeHandle - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public Fans fansPretreatment(WechatAbstractMessage message) {
        Fans fans = null;
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            if (authorizerInfo == null || !authorizerInfo.isPassedVerify() || authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
                return null;
            }
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            if (authorizationInfo == null || !authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue()))) {
                return null;
            }
            fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            if (fans == null) {
                return null;
            }
            fans.initBasicAttribute();
            if (message instanceof WechatOrdinaryMessage) {
                fans.setLastCommunicationTime(new Date());
            } else {
                fans.setLastCommunicationTime(new Date(0L));
            }
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
            log.info("wechat - MessageReceiveServiceImpl - save fans - fans:{}", (Object)fans);
        } else if (message instanceof WechatOrdinaryMessage) {
            fans.setLastCommunicationTime(new Date());
            fans.setSubscribe(Integer.valueOf(1));
            log.info("wechat - MessageReceiveServiceImpl - WechatOrdinaryMessage - update fans - fans:{}", (Object)fans);
            this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        } else if (message instanceof WechatEventMessage) {
            switch (((WechatEventMessage)message).getEvent()) {
                case SUBSCRIBE: {
                    if (fans.getSubscribe() == 1) break;
                    fans.setSubscribe(Integer.valueOf(1));
                    fans.setSubscribeTime(new Date());
                    log.info("wechat - MessageReceiveServiceImpl - SUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
                case UNSUBSCRIBE: {
                    fans.setSubscribe(Integer.valueOf(0));
                    log.info("wechat - MessageReceiveServiceImpl - UNSUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
            }
        }
        return fans;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consult.msg.queue"));
        }
        catch (Exception e) {
            log.error("init cloud account error.");
        }
    }

    @Override
    public void pushConsultation(String orgNumber, String openId) {
    }
}

