/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;
import java.util.Date;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorizationInfoServiceImpl
implements AuthorizationInfoService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationInfoServiceImpl.class);
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    @Transactional(readOnly=true)
    public AuthorizationInfo getByOrgId(Integer orgId) {
        return this.authorizationInfoDao.getByOrgId(orgId);
    }

    @Override
    @Transactional(readOnly=true)
    public AuthorizationInfo getByAuthorizerAppId(String appId) {
        return this.authorizationInfoDao.getByAuthorizerAppId(appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AuthorizationInfo addAuthorizationInfo(Integer orgId, String authCode) {
        OpenPlatformInfoDto openPlatformInfo = WechatProperties.getOpenPlatformInfo();
        String componentAccessToken = this.componentAccessTokenDao.getByAppId(openPlatformInfo.getAppId()).getComponentAccessToken();
        AuthorizationInfo newInfo = OpenPlatApiHelper.requestAuthorizationInfo(openPlatformInfo.getAppId(), componentAccessToken, authCode);
        AuthorizationInfo info = this.authorizationInfoDao.getByAuthorizerAppId(newInfo.getAuthorizerAppId());
        if (info != null && !info.getOrgId().equals(orgId)) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_ALREADY_BIND_WECHATAPP);
        }
        Date now = new Date();
        if (info == null) {
            info = newInfo;
            info.setOrgId(orgId);
            info.setCreateTime(now);
            info.setUpdateTime(now);
            this.authorizationInfoDao.save((Object)info, Boolean.valueOf(true), new String[0]);
            log.info("wechat - AuthorizationInfoServiceImpl - addAuthorizationInfo - add - info:{}", (Object)info);
            return info;
        }
        info.setOrgId(orgId);
        info.setAuthorizerAppId(newInfo.getAuthorizerAppId());
        info.setAuthorizerAccessToken(newInfo.getAuthorizerAccessToken());
        info.setAuthorizerRefershToken(newInfo.getAuthorizerRefershToken());
        info.setFuncs(newInfo.getFuncs());
        info.setExpiresIn(newInfo.getExpiresIn());
        info.setUpdateTime(now);
        this.authorizationInfoDao.update((Object)info, new String[0]);
        log.info("wechat - AuthorizationInfoServiceImpl - addAuthorizationInfo - update - info:{}", (Object)info);
        return info;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public AuthorizationInfo refreshAccessToken(Integer orgId) {
        return this.refreshAccessToken(orgId, false);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public AuthorizationInfo forceRefreshAccessToken(Integer orgId) throws BussinessException {
        return this.refreshAccessToken(orgId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationInfo refreshAccessToken(Integer orgId, boolean force) {
        AuthorizationInfo info = this.authorizationInfoDao.getByOrgId(orgId);
        if (info == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        String lock = "wechat.refresh.accesstoken.lock." + info.getAuthorizerAppId();
        if (force || info.isAccessTokenExpired()) {
            RedisConnection connection;
            block6: {
                connection = this.redisTemplate.getConnectionFactory().getConnection();
                try {
                    connection.select(WechatProperties.getRedisDB().intValue());
                    if (!connection.setNX(lock.getBytes(), "".getBytes()).booleanValue()) break block6;
                    connection.expire(lock.getBytes(), 20L);
                    OpenPlatformInfoDto openPlatformInfo = WechatProperties.getOpenPlatformInfo();
                    String componentAccessToken = this.componentAccessTokenDao.getByAppId(openPlatformInfo.getAppId()).getComponentAccessToken();
                    String authorizerAppId = info.getAuthorizerAppId();
                    String authorizerRefreshToken = info.getAuthorizerRefershToken();
                    WechatApiResponse response = OpenPlatApiHelper.requestAuthorizerAccessToken(openPlatformInfo.getAppId(), componentAccessToken, authorizerAppId, authorizerRefreshToken);
                    JSONObject rootNode = response.getRootJSONObj();
                    info.setAuthorizerAccessToken(rootNode.getString("authorizer_access_token"));
                    info.setExpiresIn(Integer.valueOf(rootNode.getInt("expires_in")));
                    info.setUpdateTime(new Date());
                    log.info("wechat - AuthorizationInfoServiceImpl - refreshAccessToken - orgId:{}, result:{}", (Object)orgId, (Object)info);
                    this.authorizationInfoDao.update((Object)info, Boolean.valueOf(true), new String[0]);
                }
                catch (Exception e) {
                    AuthorizationInfo authorizationInfo;
                    try {
                        log.warn("wechat - refreshAccessToken Exception - orgId:{},AuthorizationInfo:{}", (Object)orgId, (Object)info);
                        log.error("wechat - refreshAccessToken Exception - e", (Throwable)e);
                        authorizationInfo = null;
                    }
                    catch (Throwable throwable) {
                        connection.del((byte[][])new byte[][]{lock.getBytes()});
                        RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                        throw throwable;
                    }
                    connection.del((byte[][])new byte[][]{lock.getBytes()});
                    RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                    return authorizationInfo;
                }
            }
            connection.del((byte[][])new byte[][]{lock.getBytes()});
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return info;
    }
}

