/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.StatisticsService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiHelper;
import java.text.ParseException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;

    @Override
    public FansSCDto getFansStatistics(Integer orgId, Date beginDate, Date endDate) throws ParseException, BussinessException {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        if (authorizationInfo == null || authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        if (!authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue()))) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_AUTHORIZATION_DENIED);
        }
        if (!authorizerInfo.isPassedVerify()) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
        }
        String accessToken = this.authorizationInfoService.refreshAccessToken(authorizationInfo.getOrgId()).getAuthorizerAccessToken();
        return DataStatisticsApiHelper.getFansSCDto(accessToken, beginDate, endDate);
    }
}

