/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.composite.dao.CityDao;
import com.baijia.tianxiao.dal.composite.po.City;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMenuDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMenu;
import com.baijia.tianxiao.sal.wechat.api.OrgWechatMenuService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgWechatMenuServiceImpl
implements OrgWechatMenuService {
    private static final Logger logger = LoggerFactory.getLogger(OrgWechatMenuServiceImpl.class);
    @Autowired
    private OrgWechatMenuDao orgWechatMenuDao;
    @Autowired
    private CityDao cityDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public void delete(Integer id) {
        logger.info("wechat - del menu - id:{}", (Object)id);
        OrgWechatMenu menu = this.orgWechatMenuDao.getById(id.intValue());
        if (menu != null) {
            this.orgWechatMenuDao.delById((Serializable)menu.getId());
        } else {
            logger.warn("wechat - del null menu - id:{}", (Object)id);
        }
    }

    @Override
    public void deleteByOrgId(Integer orgId) {
        logger.info("wechat - del menu - orgId:{}", (Object)orgId);
        this.orgWechatMenuDao.deleteByOrgId(orgId.intValue());
    }

    @Override
    public List<OrgWechatMenu> getByOrgId(Integer orgId) {
        return this.orgWechatMenuDao.getByOrgId(orgId.intValue());
    }

    @Override
    public void createDefaultMenu(Integer orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        OrgWechatMenu course = this.addMenu(orgId, 1, 0, "\u673a\u6784\u8bfe\u7a0b", "");
        this.addMenu(orgId, 2, course.getId(), "\u5168\u90e8\u8bfe\u7a0b", this.getUrl(account, WechatProperties.getMOrgUrlCourse()));
        this.addMenu(orgId, 2, course.getId(), "\u641c\u7d22\u8bfe\u7a0b", this.getSearchUrl(orgInfo, WechatProperties.getMOrgUrlSearch()));
        OrgWechatMenu info = this.addMenu(orgId, 1, 0, "\u673a\u6784\u4fe1\u606f", "");
        this.addMenu(orgId, 2, info.getId(), "\u673a\u6784\u8001\u5e08", this.getUrl(account, WechatProperties.getMOrgUrlTeacher()));
        this.addMenu(orgId, 2, info.getId(), "\u673a\u6784\u7b80\u4ecb", this.getUrl(account, WechatProperties.getMOrgUrlIntro()));
        this.addMenu(orgId, 2, info.getId(), "\u673a\u6784\u76f8\u518c", this.getUrl(account, WechatProperties.getMOrgUrlPhoto()));
        this.addMenu(orgId, 2, info.getId(), "\u6821\u533a\u5730\u5740", this.getUrl(account, WechatProperties.getMOrgUrlBranches()));
        OrgWechatMenu online = this.addMenu(orgId, 1, 0, "\u5728\u7ebf\u670d\u52a1", "");
        this.addMenu(orgId, 2, online.getId(), "\u673a\u6784\u4e3b\u9875", this.getUrl(account, WechatProperties.getMOrgUrlHomePage()));
    }

    private OrgWechatMenu addMenu(Integer orgId, Integer level, Integer pid, String name, String url) {
        OrgWechatMenu menu = new OrgWechatMenu();
        menu.setOrgId(orgId);
        menu.setName(name);
        menu.setUrl(url);
        menu.setLevel(level);
        menu.setPid(pid);
        menu.setCreateTime(new Date());
        this.orgWechatMenuDao.save((Object)menu, Boolean.valueOf(true), new String[0]);
        return menu;
    }

    private String getUrl(OrgAccount account, String templateUrl) {
        return templateUrl.replaceAll("#ORG_NUM#", String.valueOf(account.getNumber()));
    }

    private String getSearchUrl(OrgInfo orgInfo, String templateUrl) {
        String url = templateUrl.replaceAll("#ORG_SHORTNAME#", orgInfo.getShortName());
        String domain = "";
        City city = (City)this.cityDao.getById((Serializable)orgInfo.getAreaId(), new String[0]);
        if (city != null && StringUtils.isNotBlank((CharSequence)city.getDomain())) {
            domain = city.getDomain() + ".";
        }
        url = url.replaceAll("#ORG_CITY#", domain);
        return url;
    }
}

