/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechatFansSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.request.MessageRequest;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatImageMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatVoiceMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.common.MessageBuilder;
import com.baijia.tianxiao.sal.wechat.helper.common.WechatCryptUtils;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.util.AudioUtil;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MessageReceiveServiceImpl
implements MessageReceiveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiveServiceImpl.class);
    private static final String RELEASE_TEST_USERNAME = "gh_3c884a361561";
    @Autowired
    private ReleaseTest releaseTest;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private CloudQueue consultMsgQueue;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String handle(MessageRequest request) {
        log.info("handle - message from wechat to app - request:{}", (Object)request);
        String xmlMsg = WechatCryptUtils.decryptMsg(request.getMsgSignature(), request.getTimestamp(), request.getNonce(), request.getPostData());
        WechatAbstractMessage message = MessageBuilder.build(xmlMsg);
        if (message.getToUserName().equals(RELEASE_TEST_USERNAME)) {
            return this.releaseTest.handleTestMsg(message);
        }
        if (message.getMsgType().equals("event")) {
            WechatEventMessage eventMessage = (WechatEventMessage)message;
            String msgKey = String.format("wechat.msg.%s.%s", eventMessage.getFromUserName(), eventMessage.getCreateTime());
            if (!this.isFirstTimeHandle(msgKey)) {
                return this.generateDefaultResponse();
            }
            if (this.fansPretreatment(eventMessage) == null) {
                return this.generateDefaultResponse();
            }
            return this.generateEventResponse(eventMessage);
        }
        try {
            WechatOrdinaryMessage ordinaryMessage = (WechatOrdinaryMessage)message;
            String msgKey = String.format("wechat.msg.%s", ordinaryMessage.getMsgId());
            if (!this.isFirstTimeHandle(msgKey)) {
                return this.generateDefaultResponse();
            }
            if (this.fansPretreatment(ordinaryMessage) == null) {
                return this.generateDefaultResponse();
            }
            return this.generateOrdinaryResponse(ordinaryMessage);
        }
        catch (Exception e) {
            try {
                log.error("handle - generateOrdinaryResponse - exception", (Throwable)e);
                return this.generateDefaultResponse();
            }
            catch (Exception e2) {
                log.error("MessageReceiveServiceImpl - handle - exception", (Throwable)e2);
                return this.generateDefaultResponse();
            }
        }
    }

    private String generateEventResponse(WechatEventMessage message) {
        if ("subscribe".equals(message.getEvent())) {
            Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
            if (fans != null) {
                fans.setSubscribe(Integer.valueOf(1));
                fans.setLastCommunicationTime(new Date());
                this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
            }
            return this.generateSubscribeEventResponse((WechatSubscribeEventMessage)message);
        }
        if ("unsubscribe".equals(message.getEvent())) {
            Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
            if (fans != null) {
                fans.setSubscribe(Integer.valueOf(0));
                this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
            }
        } else if ("SCAN".equals(message.getEvent()) || "LOCATION".equals(message.getEvent()) || "CLICK".equals(message.getEvent()) || "VIEW".equals(message.getEvent())) {
            // empty if block
        }
        return this.generateDefaultResponse();
    }

    private String generateOrdinaryResponse(WechatOrdinaryMessage message) throws WechatException, WebServiceException, Exception {
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            if (authorizerInfo == null || !authorizerInfo.isPassedVerify() || authorizerInfo.getFansSyncStatus().intValue() == WechatFansSyncStatus.ONGOING.getValue()) {
                return this.generateDefaultResponse();
            }
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            if (authorizationInfo == null) {
                return this.generateDefaultResponse();
            }
            fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            if (fans == null) {
                return this.generateDefaultResponse();
            }
            fans.initBasicAttribute();
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            fans.setLastCommunicationTime(new Date());
            this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
        } else {
            fans.setLastCommunicationTime(new Date());
            this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        }
        if ("text".equals(message.getMsgType())) {
            return this.generateTextOrdinaryResponse((WechatTextMessage)message);
        }
        if ("image".equals(message.getMsgType())) {
            return this.generateImageOrdinaryResponse((WechatImageMessage)message);
        }
        if ("voice".equals(message.getMsgType())) {
            return this.generateVoiceOrdinaryResponse((WechatVoiceMessage)message);
        }
        if ("video".equals(message.getMsgType()) || "shortvideo".equals(message.getMsgType()) || "location".equals(message.getMsgType()) || "link".equals(message.getMsgType())) {
            // empty if block
        }
        return this.generateDefaultResponse();
    }

    private String generateTextOrdinaryResponse(WechatTextMessage message) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.currentUnixTimestamp(), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setTextContent(message.getContent());
        String msg = ConsultType.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateImageOrdinaryResponse(WechatImageMessage message) throws WechatException, WebServiceException, Exception {
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        if (authorizationInfo == null) {
            return this.generateDefaultResponse();
        }
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.JPG);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            image = ImageIO.read(localFile);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block9: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateImageOrdinaryResponse - exception");
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block9;
                }
                catch (Throwable var13_15) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var13_15;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        dto = new MessageDto(MsgType.PICTURE.getValue(), DateUtil.currentUnixTimestamp(), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setImageContent(storageId, StorageUtil.constructUrl(orgStorage), imageHeight, imageWidth);
        msg = ConsultType.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateVoiceOrdinaryResponse(WechatVoiceMessage message) throws WechatException, WebServiceException, Exception {
        if (StringUtils.isNotBlank((CharSequence)message.getRecognition())) {
            textMessage = new WechatTextMessage("[\u8bed\u97f3\u8bc6\u522b] " + message.getRecognition());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        if (!message.getFormat().toLowerCase().equals("amr")) {
            textMessage = new WechatTextMessage("[\u4e0d\u652f\u6301\u7684\u8bed\u97f3\u7c7b\u578b] " + message.getFormat().toLowerCase());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.AMR);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.AMR);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            voiceLength = Integer.parseInt(AudioUtil.getAmrDuration(localFile) + "");
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block10: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateVoiceOrdinaryResponse - exception", (Throwable)e);
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block10;
                }
                catch (Throwable var11_15) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var11_15;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        dto = new MessageDto(MsgType.VOICE.getValue(), DateUtil.currentUnixTimestamp(), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setVoiceContent(storageId, StorageUtil.constructUrl(orgStorage), voiceLength);
        msg = ConsultType.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    private String generateSubscribeEventResponse(WechatSubscribeEventMessage message) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(authorizerInfo.getOrgId(), new String[0]);
            OrgTxtMsg brief = this.orgTxtMsgDao.getOrgTxtByIdAndType(authorizerInfo.getOrgId().intValue(), 3101);
            StringBuilder msg = new StringBuilder();
            String intro = "";
            if (brief != null && StringUtils.isNotBlank((CharSequence)brief.getValue())) {
                intro = brief.getValue();
            }
            msg.append("\u611f\u8c22\u5173\u6ce8\u3010").append(orgInfo.getShortName()).append("\u3011\u3002").append(intro);
            String content = msg.toString();
            String response = WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            log.info("wechat - return subscribe event response:{}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private String generateDefaultResponse() {
        return "";
    }

    private Integer saveToDb(UploadResult uploadResult, MIMEType mimeType) {
        List uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return 0;
        }
        UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(mimeType.getCode()));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStorage.setSource(Short.valueOf((short)0));
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstTimeHandle(String key) {
        log.info("Wechat - isFirstTimeHandle - check - key:{}", (Object)key);
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            log.info("Wechat - isFirstTimeHandle - redis connect - key:{}", (Object)key);
            if (connection.exists(key.getBytes()).booleanValue()) {
                log.info("Wechat - isFirstTimeHandle - not first time - key:{}" + key);
                boolean bl = false;
                return bl;
            }
            log.info("Wechat - isFirstTimeHandle - is first Time - key:{}" + key);
            connection.setEx(key.getBytes(), 20L, "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - isFirstTimeHandle - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public Fans fansPretreatment(WechatAbstractMessage message) {
        AuthorizationInfo authorizationInfo;
        AuthorizerInfo authorizerInfo;
        if (message instanceof WechatEventMessage && ((WechatEventMessage)message).getMsgType().equals("unsubscribe")) {
            return null;
        }
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            if (authorizerInfo == null || !authorizerInfo.isPassedVerify() || authorizerInfo.getFansSyncStatus().intValue() == WechatFansSyncStatus.ONGOING.getValue()) {
                return null;
            }
            authorizationInfo = null;
            try {
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            }
            catch (Exception e) {
                return null;
            }
            if (authorizationInfo == null || !authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue()))) {
                return null;
            }
            fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            if (fans == null) {
                return null;
            }
            fans.initBasicAttribute();
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            this.fansDao.useUTF8mb4();
            this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
        }
        if (fans != null && (fans.getOpenId().equals("owQJmxEhE_hgEA02KZ1oNwL-VPMM") || fans.getOpenId().equals("oeYvPvm_7ndfEFYBe0-4R8iZaHQ0") || fans.getOpenId().equals("oD6mis6nhX7Xyo2k-E7WpAlenSSs") || fans.getOpenId().equals("ohJKJjpzEMFuxFUqWk5bv3Hy128c"))) {
            authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            Fans newfans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            fans.setNick(newfans.getNick());
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            fans.setLastCommunicationTime(new Date());
            fans.setRemark("emoji test0103");
            this.fansDao.useUTF8mb4();
            this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        }
        return fans;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consult.msg.queue"));
        }
        catch (Exception e) {
            log.error("init cloud account error.");
        }
    }
}

