/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.BindingService;
import com.baijia.tianxiao.sal.wechat.dto.binding.BindingInfoDto;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BindingServiceImpl
implements BindingService {
    private static final Logger log = LoggerFactory.getLogger(BindingServiceImpl.class);
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgWechatMenuDao orgWechatMenuDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Override
    public BindingInfoDto getBindingInfo(Integer orgId) {
        AuthorizerInfo info = this.authorizerInfoDao.getByOrgId(orgId);
        if (info == null) {
            return null;
        }
        BindingInfoDto dto = new BindingInfoDto();
        dto.setAppId(info.getAuthorizerAppId());
        dto.setHeadImg(info.getHeadImg());
        dto.setNickName(info.getNickName());
        dto.setServiceType(info.getServiceType());
        dto.setVerifyType(info.getVerifyType());
        dto.setUserName(info.getUserName());
        String qrcodeUrl = null;
        if (info.getQrcodeStorageId() != null) {
            OrgStorage orgStorage = this.orgStorageDao.getById(info.getQrcodeStorageId().intValue());
            qrcodeUrl = orgStorage == null ? info.getQrcodeUrl() : StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
        }
        dto.setQrcodeUrl(qrcodeUrl);
        return dto;
    }

    @Override
    public void removeBindingInfo(Integer orgId) {
        this.orgWechatMenuDao.deleteByOrgId(orgId.intValue());
        this.authorizerInfoDao.deleteByOrgId(orgId);
        this.authorizationInfoDao.deleteByOrgId(orgId);
        log.info("wechat - removeBindingInfo - orgId:{}", (Object)orgId);
    }

    @Override
    public void removeBindingInfo(String appId) {
        AuthorizationInfo info = this.authorizationInfoDao.getByAuthorizerAppId(appId);
        if (info == null) {
            return;
        }
        this.removeBindingInfo(info.getOrgId());
    }
}

