/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.po.ComponentVerifyTicket;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationReceiveService;
import com.baijia.tianxiao.sal.wechat.api.BindingService;
import com.baijia.tianxiao.sal.wechat.api.ComponentVerifyTicketService;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationReceiveDto;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationReceiveRequest;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.common.WXBizMsgCrypt;
import com.baijia.tianxiao.sal.wechat.helper.common.XMLParse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationReceiveServiceImpl
implements AuthorizationReceiveService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationReceiveServiceImpl.class);
    @Autowired
    private BindingService bindingService;
    @Autowired
    private ComponentVerifyTicketService componentVerifyTicketService;

    @Override
    public void handle(AuthorizationReceiveRequest request) {
        try {
            String appId = WechatProperties.getOpenAppId();
            String token = WechatProperties.getOpenMsgToken();
            String encodingAesKey = WechatProperties.getEncodingAesKey();
            WXBizMsgCrypt wxBizMsgCrypt = new WXBizMsgCrypt(token, encodingAesKey, appId);
            String[] encrytMsg = XMLParse.extractTicket(request.getPostData());
            String decryptXmlMsg = wxBizMsgCrypt.decryptMsg(request.getMsgSignature(), request.getTimestamp(), request.getNonce(), encrytMsg);
            AuthorizationReceiveDto dto = AuthorizationReceiveDto.buildByXml(decryptXmlMsg);
            switch (dto.getInfoType()) {
                case "component_verify_ticket": {
                    this.handleVerifyTicket(dto);
                    break;
                }
                case "unauthorized": {
                    this.handleUnauthorization(dto);
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleVerifyTicket(AuthorizationReceiveDto dto) {
        log.info("wechat - AuthorizationReceiveServiceImpl - handleVerifyTicket - data:{}", (Object)dto);
        ComponentVerifyTicket newTicket = new ComponentVerifyTicket();
        newTicket.setAppId(dto.getAppId());
        newTicket.setInfoType(dto.getInfoType());
        newTicket.setComponentVerifyTicket(dto.getComponentVerifyTicket());
        newTicket.setCreateTime(dto.getCreateTime());
        this.componentVerifyTicketService.saveOrUpdate(newTicket);
    }

    private void handleUnauthorization(AuthorizationReceiveDto dto) {
        log.info("wechat - AuthorizationReceiveServiceImpl - handleUnauthorization - data:{}", (Object)dto);
        this.bindingService.removeBindingInfo(dto.getAuthorizerAppid());
    }
}

