/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.openplat;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.ComponentAccessToken;
import com.baijia.tianxiao.dal.wechat.po.PreAuthCode;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiCaller;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.ws.WebServiceException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPlatApiHelper {
    private static final Logger logger = LoggerFactory.getLogger(OpenPlatApiCaller.class);

    public static ComponentAccessToken requestComponentAccessToken(String componentAppId, String componentAppSecret, String componentVerifyTicket) throws WechatException, WebServiceException {
        WechatApiResponse response = OpenPlatApiCaller.requestComponentAccessToken(componentAppId, componentAppSecret, componentVerifyTicket);
        JSONObject rootNode = response.getRootJSONObj();
        if (rootNode.get("component_access_token") == null || rootNode.get("expires_in") == null) {
            throw new WebServiceException("component_access_token not exist");
        }
        ComponentAccessToken componentAccessToken = new ComponentAccessToken();
        componentAccessToken.setAppId(componentAppId);
        componentAccessToken.setComponentAccessToken(rootNode.getString("component_access_token"));
        componentAccessToken.setExpiresIn(Integer.valueOf(rootNode.getInt("expires_in")));
        componentAccessToken.setUpdateTime(new Date());
        return componentAccessToken;
    }

    public static PreAuthCode requestPreAuthCode(String componentAppId, String componentAccessToken) throws WechatException, WebServiceException {
        WechatApiResponse response = OpenPlatApiCaller.requestPreAuthCode(componentAppId, componentAccessToken);
        JSONObject rootNode = response.getRootJSONObj();
        if (rootNode.get("pre_auth_code") == null || rootNode.get("expires_in") == null) {
            throw new WebServiceException("pre_auth_code not exist");
        }
        PreAuthCode preAuthCode = new PreAuthCode();
        preAuthCode.setAppId(componentAppId);
        preAuthCode.setExpiresIn(Integer.valueOf(rootNode.getInt("expires_in")));
        preAuthCode.setPreAuthCode(rootNode.getString("pre_auth_code"));
        preAuthCode.setUpdateTime(new Date());
        return preAuthCode;
    }

    public static AuthorizationInfo requestAuthorizationInfo(String componentAppId, String componentAccessToken, String authCode) throws WechatException, WebServiceException {
        WechatApiResponse response = OpenPlatApiCaller.requestAuthorizationInfo(componentAppId, componentAccessToken, authCode);
        AuthorizationInfo authorizationInfo = new AuthorizationInfo();
        JSONObject rootNode = response.getRootJSONObj();
        JSONObject infoNode = rootNode.getJSONObject("authorization_info");
        authorizationInfo.setAuthorizerAppId(infoNode.getString("authorizer_appid"));
        authorizationInfo.setExpiresIn(Integer.valueOf(infoNode.getInt("expires_in")));
        authorizationInfo.setAuthorizerAccessToken(infoNode.getString("authorizer_access_token"));
        authorizationInfo.setAuthorizerRefershToken(infoNode.getString("authorizer_refresh_token"));
        ArrayList funcIds = Lists.newArrayList();
        JSONArray funcInfoArray = infoNode.getJSONArray("func_info");
        for (int i = 0; i < funcInfoArray.size(); ++i) {
            JSONObject funcInfoNode = funcInfoArray.getJSONObject(i);
            JSONObject funcscopeCategoryNode = funcInfoNode.getJSONObject("funcscope_category");
            Integer permissionId = funcscopeCategoryNode.getInt("id");
            funcIds.add(permissionId);
        }
        authorizationInfo.setFuncsByList((List)funcIds);
        return authorizationInfo;
    }

    public static AuthorizerInfo requestAuthorizerInfo(String componentAppId, String componentAccessToken, String authorizerAppId) throws WechatException, WebServiceException {
        WechatApiResponse response = OpenPlatApiCaller.requestAuthorizerInfo(componentAppId, componentAccessToken, authorizerAppId);
        try {
            JSONObject rootNode = response.getRootJSONObj();
            JSONObject infoNode = rootNode.getJSONObject("authorizer_info");
            AuthorizerInfo authorizerInfo = new AuthorizerInfo();
            authorizerInfo.setNickName(infoNode.optString("nick_name", ""));
            authorizerInfo.setUserName(infoNode.optString("user_name", ""));
            authorizerInfo.setHeadImg(infoNode.optString("head_img", ""));
            authorizerInfo.setAlias(infoNode.optString("alias", ""));
            authorizerInfo.setQrcodeUrl(infoNode.optString("qrcode_url", ""));
            JSONObject serviceTypeInfoNode = infoNode.getJSONObject("service_type_info");
            authorizerInfo.setServiceType(Integer.valueOf(serviceTypeInfoNode.optInt("id", 0)));
            JSONObject verifyTypeInfoNode = infoNode.getJSONObject("verify_type_info");
            authorizerInfo.setVerifyType(Integer.valueOf(verifyTypeInfoNode.optInt("id", 0)));
            return authorizerInfo;
        }
        catch (Exception e) {
            logger.error("wechat - parse response exception - ", (Throwable)e);
            throw new RuntimeException("unexpected response: " + response);
        }
    }

    public static WechatApiResponse requestAuthorizerAccessToken(String componentAppId, String componentAccessToken, String authorizerAppId, String authorizerRefreshToken) throws WechatException, WebServiceException {
        return OpenPlatApiCaller.requestAuthorizerAccessToken(componentAppId, componentAccessToken, authorizerAppId, authorizerRefreshToken);
    }
}

