
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.upload.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import org.springframework.web.multipart.MultipartFile;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.sal.upload.dto.TaskStatus;
import com.baijia.tianxiao.sal.upload.dto.UploadRecordDto;

/**
 * @title UploadService
 * @desc TODO
 * @author cxm
 * @date 2016年3月15日
 * @version 1.0
 */
public interface UploadService {

    /**
     * 提交上传的文件,并返回上传文件的编号
     * 
     * @param orgId 当前操作所属的机构
     * @param uploadType 数据类型参考 {@link DataProcType}
     * @param override 是否覆盖重复数据
     * @param file
     * @return
     * @throws IOException
     */
    public int uploadFile(final Long orgId, int uploadType, boolean override, MultipartFile file) throws IOException;

    /**
     * 获取指定任务的执行状态
     * 
     * @param orgId
     * @param taskId
     * @return
     */
    public TaskStatus getUploadStatus(final Long orgId, final Integer taskId);

    /**
     * 获取上传文件后错误数据生成的excel文件地址
     * 
     * @param orgId
     * @param taskId
     * @return 如果没有错误文件,返回空字符串
     */
    public String getErrorFileUrl(Long orgId, Integer taskId);

    /**
     * 查看上传任务的列表
     * 
     * @param orgId
     * @param startTime
     * @param endTime
     * @param uploadType
     * @param status 0:上传中,1:上传完成
     * @return
     */
    public List<UploadRecordDto> listUploadTask(final Long orgId, Date startTime, Date endTime, DataProcType uploadType,
        Integer status);

}
