/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.dto;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.upload.po.TxUploadRecords;
import com.google.common.base.Preconditions;
import java.util.Date;

public class UploadRecordDto {
    private Integer id;
    private Long orgId;
    private String orgName;
    private int uploadType;
    private String uploadTypeName;
    private int totalCount;
    private int successCount;
    private int repeatCount;
    private int failCount;
    private int status;
    private String statusStr;
    private Date createTime;
    private Date updateTime;

    public void setStatus(int status) {
        this.status = status;
        this.statusStr = status == 1 ? "\u5df2\u5b8c\u6210" : "\u5bfc\u5165\u4e2d...";
    }

    public void setUploadTypeEnum(DataProcType uploadTypeEnum) {
        if (uploadTypeEnum != null) {
            this.uploadType = uploadTypeEnum.getType();
            this.uploadTypeName = uploadTypeEnum.getNote();
        }
    }

    public static UploadRecordDto transfer(TxUploadRecords record, String orgName) {
        Preconditions.checkNotNull((Object)record, (Object)"upload record is null");
        UploadRecordDto dto = new UploadRecordDto();
        dto.setCreateTime(record.getCreateTime());
        dto.setFailCount(record.getFailCount());
        dto.setId(record.getId());
        dto.setOrgId(record.getOrgId());
        dto.setOrgName(orgName);
        dto.setRepeatCount(record.getRepeatCount());
        dto.setStatus(record.getStatus());
        dto.setSuccessCount(record.getSuccessCount());
        dto.setTotalCount(record.getTotalCount());
        dto.setUpdateTime(record.getUpdateTime());
        dto.setUploadTypeEnum(DataProcType.getByType((Integer)record.getUploadType()));
        return dto;
    }

    public Integer getId() {
        return this.id;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public int getUploadType() {
        return this.uploadType;
    }

    public String getUploadTypeName() {
        return this.uploadTypeName;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        return this.statusStr;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setUploadType(int uploadType) {
        this.uploadType = uploadType;
    }

    public void setUploadTypeName(String uploadTypeName) {
        this.uploadTypeName = uploadTypeName;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadRecordDto)) {
            return false;
        }
        UploadRecordDto other = (UploadRecordDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        if (this.getUploadType() != other.getUploadType()) {
            return false;
        }
        String this$uploadTypeName = this.getUploadTypeName();
        String other$uploadTypeName = other.getUploadTypeName();
        if (this$uploadTypeName == null ? other$uploadTypeName != null : !this$uploadTypeName.equals(other$uploadTypeName)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getSuccessCount() != other.getSuccessCount()) {
            return false;
        }
        if (this.getRepeatCount() != other.getRepeatCount()) {
            return false;
        }
        if (this.getFailCount() != other.getFailCount()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$statusStr = this.getStatusStr();
        String other$statusStr = other.getStatusStr();
        if (this$statusStr == null ? other$statusStr != null : !this$statusStr.equals(other$statusStr)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadRecordDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        result = result * 59 + this.getUploadType();
        String $uploadTypeName = this.getUploadTypeName();
        result = result * 59 + ($uploadTypeName == null ? 43 : $uploadTypeName.hashCode());
        result = result * 59 + this.getTotalCount();
        result = result * 59 + this.getSuccessCount();
        result = result * 59 + this.getRepeatCount();
        result = result * 59 + this.getFailCount();
        result = result * 59 + this.getStatus();
        String $statusStr = this.getStatusStr();
        result = result * 59 + ($statusStr == null ? 43 : $statusStr.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "UploadRecordDto(id=" + this.getId() + ", orgId=" + this.getOrgId() + ", orgName=" + this.getOrgName() + ", uploadType=" + this.getUploadType() + ", uploadTypeName=" + this.getUploadTypeName() + ", totalCount=" + this.getTotalCount() + ", successCount=" + this.getSuccessCount() + ", repeatCount=" + this.getRepeatCount() + ", failCount=" + this.getFailCount() + ", status=" + this.getStatus() + ", statusStr=" + this.getStatusStr() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

