package com.baijia.tianxiao.sal.upload.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;

@Data
public class TaskStatus implements Serializable{

	private static final long serialVersionUID = 9097127701606288406L;
	
	private Integer uploadType;
	
	private String fileName;
	
	private boolean override;
	
	private List<String> headers;
	

    private int totalCount;

    private int successCount;

    private int repeatCount;

    private int failCount;

    private int completeCount;

    private int completeRate;

    private String errorFileUrl;

    private Exception exception;
    
    public void clear(){
    	this.totalCount = 0;
    	this.successCount=0;
    	this.repeatCount=0;
    	this.failCount=0;
    	this.completeCount=0;
    	this.completeRate=0;
    	this.errorFileUrl=null;
    	this.exception=null;
    }

    /**
     * @param headers2
     * @param totalCount
     */
    public TaskStatus(List<String> headers2, int totalCount) {
        this.headers = headers2;
        this.totalCount = totalCount;
    }

    public TaskStatus() {
    }

    public void increaseSuccessCount() {
        increaseCompleteCount();
        this.successCount++;
    }

    public void increaseRepeatCount() {
        increaseCompleteCount();
        this.repeatCount++;
    }

    public void increaseFailCount() {
        increaseCompleteCount();
        this.failCount++;
    }

    public void increaseCompleteCount() {
        this.completeCount++;
    }

    public int getCompleteRate() {
        if (totalCount == 0) {
            return 0;
        }
        if (this.completeCount == this.totalCount) {
            completeRate = 100;
        } else {
            this.completeRate = new BigDecimal(completeCount).multiply(new BigDecimal(100))
                .divide(new BigDecimal(totalCount), RoundingMode.DOWN).intValue();
        }
        return this.completeRate;
    }

}