/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.service.impl;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class CsvUploadFileReaderServiceImpl
implements UploadFileReaderService {
    private static final Logger log = LoggerFactory.getLogger(CsvUploadFileReaderServiceImpl.class);
    private MultipartFile csvFile;
    private BufferedReader br;
    private boolean isComplete;
    private int count;
    private boolean useStream;
    private int index;
    private List<Object[]> datas;

    public CsvUploadFileReaderServiceImpl(MultipartFile csvFile, boolean useStream) {
        Preconditions.checkArgument((csvFile != null && !csvFile.isEmpty() ? 1 : 0) != 0, (Object)"csv file is not exist");
        this.csvFile = csvFile;
        this.useStream = useStream;
        this.initReader();
    }

    private synchronized void initReader() {
        block6: {
            if (this.br == null && !this.isComplete) {
                try {
                    this.br = new BufferedReader(new InputStreamReader(this.csvFile.getInputStream(), "GBK"));
                    if (this.useStream || this.datas != null) break block6;
                    try {
                        this.datas = this.readDatas();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("get data length error");
                    }
                }
                catch (FileNotFoundException e) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u4f20\u7684\u6587\u4ef6\u9519\u8bef");
                }
                catch (IOException e) {
                    log.error("init csv reader catch error:", (Throwable)e);
                    IOUtils.closeQuietly((Reader)this.br);
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfb\u53d6\u6587\u4ef6\u4fe1\u606f\u9519\u8bef");
                }
            }
        }
    }

    @Override
    public int getDataLength() throws IOException {
        this.initReader();
        if (!this.isComplete) {
            throw new UnsupportedOperationException("can not get data length from csv file before read all data");
        }
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] readData() throws IOException {
        String line = null;
        try {
            this.initReader();
            if (!this.useStream) {
                if (this.index >= this.count) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                Object[] objectArray = this.datas.get(this.index++);
                return objectArray;
            }
            while ((line = this.br.readLine()) != null) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{line})) continue;
                ++this.count;
                Object[] objectArray = StringUtils.split((String)line, (char)',');
                return objectArray;
            }
        }
        catch (FileNotFoundException e) {
            log.error("init reader error,", (Throwable)e);
        }
        catch (Exception e) {
            log.error("read data get error:", (Throwable)e);
        }
        finally {
            if (line == null) {
                IOUtils.closeQuietly((Reader)this.br);
            }
        }
        this.isComplete = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object[]> readDatas() throws IOException {
        ArrayList results = Lists.newArrayList();
        try {
            this.initReader();
            if (this.datas != null) {
                List<Object[]> list = this.datas;
                return list;
            }
            String line = null;
            while ((line = this.br.readLine()) != null) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{line})) continue;
                ++this.count;
                results.add(StringUtils.splitPreserveAllTokens((String)line, (char)','));
            }
        }
        catch (FileNotFoundException e) {
            log.error("init reader error,", (Throwable)e);
        }
        catch (Exception e) {
            log.error("read data catch error:", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)this.br);
        }
        this.isComplete = true;
        return results;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.br);
    }

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File("/Users/zhenyujian/Desktop/CRM-\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f.xlsx")), "gbk"));
        String line = null;
        ArrayList datas = Lists.newArrayList();
        while ((line = br.readLine()) != null) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{line})) continue;
            String[] data = StringUtils.splitPreserveAllTokens((String)line, (char)',');
            System.out.println("line:" + line + " split data:" + ArrayUtils.toString((Object)data));
            datas.add(data);
        }
        System.out.println(datas);
        br.close();
    }
}

