/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.tuiguang.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.dal.advisory.dao.OrgStudentAdvisoryDao;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceStatisticsDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceStatistics;
import com.baijia.tianxiao.dal.course.dao.ClassCoursePhotoDao;
import com.baijia.tianxiao.dal.course.dao.ClassCourseScheduleDao;
import com.baijia.tianxiao.dal.course.dao.SubjectDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.ClassCoursePhoto;
import com.baijia.tianxiao.dal.course.po.ClassCourseSchedule;
import com.baijia.tianxiao.dal.course.po.Subject;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClickLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseAccessDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPVDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClickLog;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPV;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.tuiguang.api.CourseAdvertiseService;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseDetailRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CoursePvRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseTransformRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CallResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CategoryListResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CommonInfoResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseDetailResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseListPageResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseListResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CoursePvResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseTransformResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.DiscoveryResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.GalaxyCallResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.GalaxyTopSearchResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.OrgTransformResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.RefuseInfo;
import com.baijia.tianxiao.sal.tuiguang.dto.response.TopSearch;
import com.baijia.tianxiao.sal.tuiguang.dto.response.UserLevelResponseDto;
import com.baijia.tianxiao.sal.tuiguang.enums.Discovery;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.date.JodaDateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Service;

@Service(value="courseAdvertiseService")
public class CourseAdvertiseServiceImpl
extends ApplicationObjectSupport
implements CourseAdvertiseService {
    private static final Logger log = LoggerFactory.getLogger(CourseAdvertiseServiceImpl.class);
    @Autowired
    OrgAccountDao orgAccountDao;
    @Autowired
    OrgInfoDao orgInfoDao;
    @Autowired
    SubjectDao subjectDao;
    @Autowired
    TeacherClassCourseDao teacherClassCourseDao;
    @Autowired
    OrgCourseDao orgCourseDao;
    @Autowired
    OrgCourseAccessDao orgCourseAccessDao;
    @Autowired
    CoursePurchaseDao coursePurchaseDao;
    @Autowired
    OrgStudentAdvisoryDao orgStudentAdvisoryDao;
    @Autowired
    MessageDao messageDao;
    @Autowired
    OrgPVDao orgPVDao;
    @Autowired
    ImMessageInfoDao imMessageInfoDao;
    @Autowired
    TeacherDao teacherDao;
    @Autowired
    VideoCourseDao videoCourseDao;
    @Autowired
    OrgClickLogDao orgClickLogDao;
    @Autowired
    ClassCourseScheduleDao classCourseScheduleDao;
    @Autowired
    CallServiceStatisticsDao callServiceStatisticsDao;
    @Autowired
    OrgClassLessonDao orgClassLessonDao;
    @Autowired
    ClassCoursePhotoDao classCoursePhotoDao;
    @Autowired
    StorageDao storageDao;
    @Autowired
    OrgCourseTeacherDao orgCourseTeacherDao;
    @Value(value="${galaxy.appid.config}")
    private String galaxyAppid;
    @Value(value="${galaxy.database.config}")
    private String galaxyDatabase;
    @Value(value="${galaxy.query.api}")
    private String galaxyQueryApi;
    @Value(value="${storage.server.url}")
    private String storageServerUrl;
    @Value(value="${teacher.course.url}")
    private String teacherCourseUrl;
    @Value(value="${org.course.url}")
    private String orgCourseUrl;
    @Value(value="${user.level.url}")
    private String userLevelUrl;
    @Value(value="${tianxiao.yingxiao.sendactivity}")
    private String sendActivityUrl;
    @Value(value="${tiaoxiao.yingxiao.promotion}")
    private String promotionUrl;
    @Value(value="${tiaoxiao.yingxiao.coupon}")
    private String couponUrl;
    @Value(value="${tiaoxiao.yingxiao.smartpromotion}")
    private String smartPromotionUrl;
    @Value(value="${tiaoxiao.yingxiao.displayitems}")
    private String displayItems;
    @Value(value="${tiaoxiao.yingxiao.rushroomurl}")
    private String rushSourceUrl;
    @Value(value="${tiaoxiao.yingxiao.rentroomurl}")
    private String rentRoomUrl;
    @Value(value="${tiaoxiao.yingxiao.drawUrl}")
    private String drawActivityUrl;
    @Value(value="${tiaoxiao.yingxiao.voteUrl}")
    private String voteActivityUrl;
    @Value(value="${tiaoxiao.yingxiao.groupSendUrl}")
    private String groupSendUrl;
    @Value(value="${tiaoxiao.yingxiao.discount}")
    private String discountUrl;
    @Value(value="${tiaoxiao.yingxiao.benefit}")
    private String benefitUrl;
    @Value(value="${tiaoxiao.yingxiao.referral}")
    private String referralActivityUrl;
    @Value(value="${tiaoxiao.yingxiao.article}")
    private String articleActivityUrl;

    @Override
    public CourseListPageResponse getCourseList(int orgId, CourseListRequestDto courseListRequestDto) {
        List teachers;
        List videoCourseList;
        List subList;
        int pageNum = courseListRequestDto.getPageNum();
        int pageSize = courseListRequestDto.getPageSize();
        int offset = (pageNum - 1) * pageSize;
        ArrayList responseList = Lists.newArrayList();
        int totalCount = 0;
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        int orgNumber = orgAccount.getNumber();
        int type = courseListRequestDto.getType();
        int sortOrder = courseListRequestDto.getSortOrder();
        String courseTypes = courseListRequestDto.getCourseType();
        String categoryIds = courseListRequestDto.getCategoryId();
        if (type == 1) {
            List courseList = this.teacherClassCourseDao.getVisualTeacherCourseByOrgNumber(Integer.valueOf(orgNumber), categoryIds, courseTypes, sortOrder);
            List subList2 = ListUtil.getSubList((List)courseList, (int)offset, (int)pageSize);
            if (CollectionUtils.isNotEmpty((Collection)subList2)) {
                totalCount = courseList.size();
                for (TeacherClassCourse teacherClassCourse : subList2) {
                    CourseListResponseDto courseListResponseDto = new CourseListResponseDto();
                    courseListResponseDto.setCourseName(teacherClassCourse.getName());
                    courseListResponseDto.setPrior(teacherClassCourse.getExtendStatus());
                    if (teacherClassCourse.getExtendStatus() != null && teacherClassCourse.getExtendStatus() == 1 && (teacherClassCourse = this.teacherClassCourseDao.getTeacherClassCourse(Integer.valueOf(orgNumber), teacherClassCourse.getNumber())).getLastSetTime() != null && new Date().getTime() - teacherClassCourse.getLastSetTime().getTime() >= 0x6DDD00L) {
                        courseListResponseDto.setPv(teacherClassCourse.getPageView());
                        courseListResponseDto.setTransform(teacherClassCourse.getTransform());
                    }
                    courseListResponseDto.setStar(teacherClassCourse.getRank());
                    courseListResponseDto.setType(type);
                    courseListResponseDto.setCourseNumber(teacherClassCourse.getNumber());
                    responseList.add(courseListResponseDto);
                }
            }
        } else if (type == 2) {
            List orgCourseList = this.orgCourseDao.getVisualOrgCourseByOrgNumber(Integer.valueOf(orgNumber), categoryIds, sortOrder, null, null, null);
            List subList3 = ListUtil.getSubList((List)orgCourseList, (int)offset, (int)pageSize);
            if (CollectionUtils.isNotEmpty((Collection)subList3)) {
                totalCount = orgCourseList.size();
                for (OrgCourse orgCourse : subList3) {
                    CourseListResponseDto courseListResponseDto = new CourseListResponseDto();
                    courseListResponseDto.setCourseName(orgCourse.getName());
                    courseListResponseDto.setPrior(orgCourse.getExtendStatus());
                    courseListResponseDto.setStar(orgCourse.getRank());
                    if (orgCourse.getExtendStatus() != null && orgCourse.getExtendStatus() == 1 && (orgCourse = this.orgCourseDao.getOrgCourse(Integer.valueOf(orgNumber), orgCourse.getNumber())).getLastSetTime() != null && new Date().getTime() - orgCourse.getLastSetTime().getTime() >= 0x6DDD00L) {
                        courseListResponseDto.setPv(orgCourse.getPageView());
                        courseListResponseDto.setTransform(orgCourse.getTransform());
                    }
                    courseListResponseDto.setType(type);
                    courseListResponseDto.setCourseNumber(orgCourse.getNumber());
                    responseList.add(courseListResponseDto);
                }
            }
        } else if (type == 3 && CollectionUtils.isNotEmpty((Collection)(subList = ListUtil.getSubList((List)(videoCourseList = this.videoCourseDao.getTeacherVideoCourse(teachers = this.teacherDao.getTeachersByOrgId(Long.valueOf(orgId), null, new String[0]), sortOrder, categoryIds)), (int)offset, (int)pageSize)))) {
            totalCount = videoCourseList.size();
            for (VideoCourse videoCourse : subList) {
                CourseListResponseDto courseListResponseDto = new CourseListResponseDto();
                courseListResponseDto.setCourseName(videoCourse.getName());
                courseListResponseDto.setPrior(0);
                courseListResponseDto.setStar(0);
                courseListResponseDto.setPv(videoCourse.getPageView());
                courseListResponseDto.setTransform(videoCourse.getTransform());
                courseListResponseDto.setType(type);
                responseList.add(courseListResponseDto);
            }
        }
        CourseListPageResponse courseListPageResponse = new CourseListPageResponse();
        courseListPageResponse.setList(responseList);
        courseListPageResponse.setTotalCount(totalCount);
        return courseListPageResponse;
    }

    @Override
    public List<RefuseInfo> getRejectReason(int orgId, long courseNumber, int type) {
        OrgAccount orgAccount;
        TeacherClassCourse classCourse;
        if (type == 1 && (classCourse = this.teacherClassCourseDao.getTeacherClassCourse((orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0])).getNumber(), Long.valueOf(courseNumber))) != null && StringUtils.isNotBlank((CharSequence)classCourse.getReason())) {
            try {
                Gson gson = new Gson();
                return (List)gson.fromJson(classCourse.getReason(), new TypeToken<List<RefuseInfo>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<CategoryListResponseDto> getCategory(int orgId, int type) {
        ArrayList responseList;
        block7: {
            List teachers;
            List videoCourseList;
            block8: {
                int orgNumber;
                block6: {
                    List subjectList;
                    responseList = Lists.newArrayList();
                    OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
                    orgNumber = orgAccount.getNumber();
                    if (type != 1) break block6;
                    List courseList = this.teacherClassCourseDao.getVisualTeacherCourseByOrgNumber(Integer.valueOf(orgNumber), null, null, -1);
                    TreeSet<Integer> collSet = new TreeSet<Integer>();
                    for (Object teacherClassCourse : courseList) {
                        collSet.add(teacherClassCourse.getSubjectid().intValue());
                    }
                    if (!CollectionUtils.isNotEmpty(collSet) || !CollectionUtils.isNotEmpty((Collection)(subjectList = this.subjectDao.getByIds(collSet, new String[0])))) break block7;
                    for (Subject subject : subjectList) {
                        CategoryListResponseDto categoryListResponseDto = new CategoryListResponseDto();
                        categoryListResponseDto.setId(String.valueOf(subject.getId()));
                        categoryListResponseDto.setName(subject.getRemark_name());
                        responseList.add(categoryListResponseDto);
                    }
                    break block7;
                }
                if (type != 2) break block8;
                List orgCourseList = this.orgCourseDao.getVisualOrgCourseByOrgNumber(Integer.valueOf(orgNumber), null, -1, null, null, null);
                TreeSet<Integer> collSet = new TreeSet<Integer>();
                Object subjectList = orgCourseList.iterator();
                while (subjectList.hasNext()) {
                    OrgCourse orgCourse = (OrgCourse)subjectList.next();
                    collSet.add(orgCourse.getSubjectId());
                }
                if (!CollectionUtils.isNotEmpty(collSet) || !CollectionUtils.isNotEmpty((Collection)(subjectList = this.subjectDao.getByIds(collSet, new String[0])))) break block7;
                Iterator iterator = subjectList.iterator();
                while (iterator.hasNext()) {
                    Subject subject = (Subject)iterator.next();
                    CategoryListResponseDto categoryListResponseDto = new CategoryListResponseDto();
                    categoryListResponseDto.setId(String.valueOf(subject.getId()));
                    categoryListResponseDto.setName(subject.getRemark_name());
                    responseList.add(categoryListResponseDto);
                }
                break block7;
            }
            if (type == 3 && CollectionUtils.isNotEmpty((Collection)(videoCourseList = this.videoCourseDao.getTeacherVideoCourse(teachers = this.teacherDao.getTeachersByOrgId(Long.valueOf(orgId), null, new String[0]), -1, null)))) {
                HashSet<String> collSet = new HashSet<String>();
                for (VideoCourse videoCourse : videoCourseList) {
                    if (collSet.contains(videoCourse.getSubjectId()) || !StringUtils.isNotEmpty((CharSequence)videoCourse.getSubjectId())) continue;
                    CategoryListResponseDto categoryListResponseDto = new CategoryListResponseDto();
                    categoryListResponseDto.setId(videoCourse.getSubjectId());
                    String name = videoCourse.getSubjectId();
                    name = StringUtils.substringAfterLast((String)name, (String)",");
                    categoryListResponseDto.setName(name);
                    responseList.add(categoryListResponseDto);
                    collSet.add(videoCourse.getSubjectId());
                }
            }
        }
        return responseList;
    }

    @Override
    public CoursePvResponseDto getCoursePv(int orgId, CoursePvRequestDto coursePvRequestDto) {
        OrgCourse orgCourse;
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        int orgNumber = orgAccount.getNumber();
        long courseNum = coursePvRequestDto.getCourseNumber();
        int type = coursePvRequestDto.getType();
        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)1));
        Integer courseTotalPv = null;
        Integer coursePeroidPv = null;
        boolean isAfterHours = false;
        if (type == 1) {
            TeacherClassCourse teacherClassCourse = this.teacherClassCourseDao.getTeacherClassCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNum));
            if (teacherClassCourse != null && teacherClassCourse.getExtendStatus() != null && teacherClassCourse.getExtendStatus() == 1 && teacherClassCourse.getPageView() != null && teacherClassCourse.getLastSetTime() != null && new Date().getTime() - teacherClassCourse.getLastSetTime().getTime() >= 0x6DDD00L) {
                isAfterHours = true;
                courseTotalPv = teacherClassCourse.getPageView();
            }
        } else if (type == 2 && (orgCourse = this.orgCourseDao.getOrgCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNum))) != null && orgCourse.getExtendStatus() != null && orgCourse.getExtendStatus() == 1 && orgCourse.getPageView() != null && orgCourse.getLastSetTime() != null && new Date().getTime() - orgCourse.getLastSetTime().getTime() >= 0x6DDD00L) {
            isAfterHours = true;
            courseTotalPv = orgCourse.getPageView();
        }
        if (isAfterHours && (coursePeroidPv = Integer.valueOf(this.orgCourseAccessDao.getCoursePeroidPv(courseNum, startDate, endDate))) > courseTotalPv) {
            coursePeroidPv = courseTotalPv;
        }
        CoursePvResponseDto coursePvResponseDto = new CoursePvResponseDto();
        coursePvResponseDto.setPv(coursePeroidPv);
        coursePvResponseDto.setPvTotal(courseTotalPv);
        return coursePvResponseDto;
    }

    @Override
    public String setCoursePrior(int orgId, long courseNum, int type, int prior) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        int orgNumber = orgAccount.getNumber();
        if (prior == 1) {
            int userLevel = this.getUserLevel(orgAccount.getNumber().intValue());
            if (userLevel == 0 || userLevel == 1) {
                return "\u4f18\u5148\u63a8\u5e7f\u4ec5\u63d0\u4f9b\u7ed9\u673a\u6784\u4f1a\u5458\uff0c\u5347\u7ea7\u4f1a\u5458\u8bf7\u8054\u7cfb\u60a8\u7684\u5e08\u8d44\u987e\u95ee";
            }
            int priorCount = this.teacherClassCourseDao.getAdvertiseCourseCount(Integer.valueOf(orgNumber)) + this.orgCourseDao.getAdvertiseCourseCount(Integer.valueOf(orgNumber), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null);
            if (userLevel == 2 && priorCount >= 1) {
                return "\u91d1\u5361\u4f1a\u5458\u53ea\u80fd\u4f18\u5148\u63a8\u5e7f\u4e00\u95e8\u8bfe\u7a0b\uff0c\u5347\u7ea7\u4f1a\u5458\u8bf7\u8054\u7cfb\u60a8\u7684\u5e08\u8d44\u987e\u95ee";
            }
            if (userLevel == 3 && priorCount >= 2) {
                return "\u767d\u91d1\u5361\u4f1a\u5458\u53ea\u80fd\u4f18\u5148\u63a8\u5e7f\u4e24\u95e8\u8bfe\u7a0b\uff0c\u5347\u7ea7\u4f1a\u5458\u8bf7\u8054\u7cfb\u60a8\u7684\u5e08\u8d44\u987e\u95ee";
            }
            if (userLevel == 4 && priorCount >= 3) {
                return "\u94bb\u77f3\u5361\u4f1a\u5458\u53ea\u80fd\u4f18\u5148\u63a8\u5e7f\u4e09\u95e8\u8bfe\u7a0b\uff0c\u8bf7\u5173\u95ed\u5176\u4ed6\u8bfe\u7a0b\u7684\u4f18\u5148\u63a8\u5e7f";
            }
        }
        if (type == 1) {
            TeacherClassCourse teacherClassCourse = this.teacherClassCourseDao.getTeacherClassCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNum));
            teacherClassCourse.setExtendStatus(Integer.valueOf(prior));
            if (prior == 1) {
                teacherClassCourse.setLastSetTime(new Date());
                this.teacherClassCourseDao.update((Object)teacherClassCourse, new String[0]);
            } else {
                teacherClassCourse.setLastSetTime(null);
                this.teacherClassCourseDao.update((Object)teacherClassCourse, Boolean.valueOf(true), new String[0]);
            }
        } else if (type == 2) {
            OrgCourse orgCourse = this.orgCourseDao.getOrgCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNum));
            orgCourse.setExtendStatus(Integer.valueOf(prior));
            if (prior == 1) {
                orgCourse.setLastSetTime(new Date());
                this.orgCourseDao.update((Object)orgCourse, new String[0]);
            } else {
                orgCourse.setLastSetTime(null);
                this.orgCourseDao.update((Object)orgCourse, Boolean.valueOf(true), new String[0]);
            }
        }
        return null;
    }

    @Override
    public CourseTransformResponseDto getTransformData(int orgId, CourseTransformRequestDto courseTransformRequestDto) {
        OrgCourse orgCourse;
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        int orgNumber = orgAccount.getNumber();
        int type = courseTransformRequestDto.getType();
        long courseNumber = courseTransformRequestDto.getCourseNumber();
        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)0));
        boolean isAfterHours = false;
        Integer reserverBill = null;
        Integer transTotal = null;
        Integer purchase = null;
        Integer callCount = null;
        if (type == 1) {
            TeacherClassCourse teacherClassCourse = this.teacherClassCourseDao.getTeacherClassCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNumber));
            if (teacherClassCourse != null && teacherClassCourse.getTransform() != null && teacherClassCourse.getExtendStatus() != null && teacherClassCourse.getExtendStatus() == 1 && teacherClassCourse.getLastSetTime() != null && new Date().getTime() - teacherClassCourse.getLastSetTime().getTime() >= 0x6DDD00L) {
                isAfterHours = true;
                transTotal = teacherClassCourse.getTransform();
                reserverBill = this.orgStudentAdvisoryDao.getPeroidTeacherCourseAdvisory(Long.valueOf(courseNumber), startDate, endDate);
            }
        } else if (type == 2 && (orgCourse = this.orgCourseDao.getOrgCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNumber))) != null && orgCourse.getTransform() != null & orgCourse.getExtendStatus() != null && orgCourse.getExtendStatus() == 1 && orgCourse.getLastSetTime() != null && new Date().getTime() - orgCourse.getLastSetTime().getTime() >= 0x6DDD00L) {
            isAfterHours = true;
            transTotal = orgCourse.getTransform();
            reserverBill = this.orgStudentAdvisoryDao.getPeroidOrgCourseAdvisory(Long.valueOf(courseNumber), startDate, endDate);
        }
        if (isAfterHours) {
            purchase = this.coursePurchaseDao.getCourseCountByTime(Long.valueOf(orgId), Long.valueOf(courseNumber), startDate, endDate);
            callCount = this.callServiceStatisticsDao.getPeroidStatistics(Long.valueOf(courseNumber), startDate, endDate);
        }
        CourseTransformResponseDto courseTransformResponseDto = new CourseTransformResponseDto();
        courseTransformResponseDto.setCourseNumber(courseNumber);
        courseTransformResponseDto.setPurchase(purchase);
        courseTransformResponseDto.setReserverBill(reserverBill);
        courseTransformResponseDto.setPhone(callCount);
        courseTransformResponseDto.setTransTotal(transTotal);
        return courseTransformResponseDto;
    }

    @Override
    public CourseDetailResponseDto getCourseDetail(int orgId, CourseDetailRequestDto courseDetailRequestDto) {
        OrgCourse orgCourse;
        int type = courseDetailRequestDto.getType();
        long courseNumber = courseDetailRequestDto.getCourseNumber();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        int orgNumber = orgAccount.getNumber();
        CourseDetailResponseDto courseDetailResponseDto = new CourseDetailResponseDto();
        if (type == 1) {
            TeacherClassCourse teacherClassCourse = this.teacherClassCourseDao.getTeacherClassCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNumber));
            if (teacherClassCourse != null) {
                Subject subject;
                courseDetailResponseDto.setCourseName(teacherClassCourse.getName());
                if (teacherClassCourse.getLessonWay() == 2) {
                    courseDetailResponseDto.setPlace("\u5728\u7ebf\u6388\u8bfe");
                } else {
                    courseDetailResponseDto.setPlace(teacherClassCourse.getAddress());
                }
                courseDetailResponseDto.setPlan(teacherClassCourse.getArrangement());
                courseDetailResponseDto.setPrior(teacherClassCourse.getExtendStatus());
                courseDetailResponseDto.setStar(teacherClassCourse.getRank());
                courseDetailResponseDto.setCourseId(teacherClassCourse.getId());
                courseDetailResponseDto.setCourseNumber(teacherClassCourse.getNumber());
                courseDetailResponseDto.setCourseUrl(this.teacherCourseUrl + teacherClassCourse.getNumber());
                ClassCoursePhoto classCoursePhoto = (ClassCoursePhoto)this.classCoursePhotoDao.getById((Serializable)teacherClassCourse.getCover(), new String[0]);
                if (classCoursePhoto != null && classCoursePhoto.getStorageId() != null) {
                    courseDetailResponseDto.setCourseImg(this.getImageUrl(classCoursePhoto.getStorageId()));
                }
                if (teacherClassCourse.getSubjectid() != null && (subject = (Subject)this.subjectDao.getById((Serializable)teacherClassCourse.getSubjectid(), new String[0])) != null) {
                    courseDetailResponseDto.setCategoryName(subject.getRemark_name());
                }
                StringBuffer sb = new StringBuffer();
                ArrayList<Long> courseNumbers = new ArrayList<Long>();
                courseNumbers.add(courseNumber);
                HashSet<Long> userIdSet = new HashSet<Long>();
                List scheduleList = this.classCourseScheduleDao.getCoursseSchedule(courseNumbers, null, Long.valueOf(orgNumber), new String[0]);
                if (CollectionUtils.isNotEmpty((Collection)scheduleList)) {
                    for (ClassCourseSchedule classCourseSchedule : scheduleList) {
                        Teacher teacher = this.teacherDao.getByUserId(classCourseSchedule.getTeacherId(), new String[0]);
                        if (teacher == null || userIdSet.contains(classCourseSchedule.getTeacherId())) continue;
                        userIdSet.add(classCourseSchedule.getTeacherId());
                        int privateProtected = teacher.getPrivateProtected();
                        String privateStr = Integer.toBinaryString(privateProtected);
                        if (privateStr.substring(privateStr.length() - 1).equals("1")) {
                            sb.append(teacher.getNickName()).append(",");
                            continue;
                        }
                        sb.append(teacher.getRealName()).append(",");
                    }
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                courseDetailResponseDto.setTeacher(sb.toString());
                List<Integer> suggestions = this.getSuggest(type, teacherClassCourse.getRank(), teacherClassCourse.getExtendStatus(), teacherClassCourse.getNumber(), orgId);
                courseDetailResponseDto.setSuggestions(suggestions);
            }
        } else if (type == 2 && (orgCourse = this.orgCourseDao.getOrgCourse(Integer.valueOf(orgNumber), Long.valueOf(courseNumber))) != null) {
            Subject subject;
            List teachers = this.orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
            HashSet<Long> userIdSet = new HashSet<Long>();
            StringBuffer sb = new StringBuffer();
            if (CollectionUtils.isNotEmpty((Collection)teachers)) {
                for (Long userid : teachers) {
                    Teacher teacher = this.teacherDao.getByUserId(userid, new String[0]);
                    if (teacher == null || userIdSet.contains(userid)) continue;
                    userIdSet.add(userid);
                    int privateProtected = teacher.getPrivateProtected();
                    String privateStr = Integer.toBinaryString(privateProtected);
                    if (privateStr.substring(privateStr.length() - 1).equals("1")) {
                        sb.append(teacher.getNickName()).append(",");
                        continue;
                    }
                    sb.append(teacher.getRealName()).append(",");
                }
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            } else {
                sb.append("\u5f85\u5b9a");
            }
            courseDetailResponseDto.setTeacher(sb.toString());
            courseDetailResponseDto.setCourseName(orgCourse.getName());
            courseDetailResponseDto.setPlace(orgCourse.getAddress());
            if (StringUtils.isBlank((CharSequence)orgCourse.getLessonSummary())) {
                courseDetailResponseDto.setPlan("\u5f85\u5b9a");
            } else {
                courseDetailResponseDto.setPlan(orgCourse.getLessonSummary());
            }
            courseDetailResponseDto.setPrior(orgCourse.getExtendStatus());
            courseDetailResponseDto.setStar(orgCourse.getRank());
            courseDetailResponseDto.setCourseId(orgCourse.getId());
            courseDetailResponseDto.setCourseNumber(orgCourse.getNumber());
            courseDetailResponseDto.setCourseUrl(this.orgCourseUrl + orgCourse.getNumber());
            courseDetailResponseDto.setCourseImg(this.getImageUrl(orgCourse.getCover() == null ? null : Long.valueOf(orgCourse.getCover().longValue())));
            if (orgCourse.getSubjectId() != null && (subject = (Subject)this.subjectDao.getById((Serializable)orgCourse.getSubjectId(), new String[0])) != null) {
                courseDetailResponseDto.setCategoryName(subject.getRemark_name());
            }
            List<Integer> suggestions = this.getSuggest(type, orgCourse.getRank(), orgCourse.getExtendStatus(), orgCourse.getNumber(), orgId);
            courseDetailResponseDto.setSuggestions(suggestions);
        }
        return courseDetailResponseDto;
    }

    private String getImageUrl(Long storageId) {
        String url = "";
        if (storageId == null) {
            return url;
        }
        Storage storage = (Storage)this.storageDao.getById((Serializable)storageId, new String[0]);
        if (storage != null) {
            String imgType = CourseAdvertiseServiceImpl.getImageType(storage.getMimetype());
            url = this.storageServerUrl + storage.getFid() + "_" + storage.getSn() + imgType;
        }
        return url;
    }

    private static String getImageType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return "";
        }
        if (type.contains("gif")) {
            return ".gif";
        }
        if (type.contains("jpeg")) {
            return ".jpeg";
        }
        if (type.contains("png")) {
            return ".png";
        }
        if (type.contains("jpg")) {
            return ".jpg";
        }
        return "--";
    }

    private List<Integer> getSuggest(int type, Integer rank, Integer extendStatus, long courseNum, int orgId) {
        ArrayList<Integer> suggestList = new ArrayList<Integer>();
        if (rank == null || extendStatus == null) {
            return suggestList;
        }
        if (type == 1) {
            if (rank == 2) {
                suggestList.add(1);
                suggestList.add(2);
            } else if (rank == 3 || rank == 4 || rank == 5) {
                suggestList.add(1);
                suggestList.add(3);
                suggestList.add(4);
            }
        } else if (type == 2) {
            if (rank == 2) {
                suggestList.add(1);
                suggestList.add(5);
                suggestList.add(2);
            } else if (rank == 3 || rank == 4 || rank == 5) {
                suggestList.add(1);
                suggestList.add(3);
                suggestList.add(4);
            }
        }
        return suggestList;
    }

    @Override
    public Map<String, Object> getOrgPv(int orgId) {
        HashMap resultMap = Maps.newHashMap();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        long orgNumber = orgAccount.getNumber().longValue();
        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)30));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)0));
        List pvList = this.orgPVDao.getOrgPv(Long.valueOf(orgNumber), startDate, endDate);
        TreeMap<String, Integer> pvMap = new TreeMap<String, Integer>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty((Collection)pvList)) {
            for (OrgPV orgPv : pvList) {
                String dateStr = sdf.format(orgPv.getDate());
                pvMap.put(dateStr, orgPv.getView());
            }
        }
        resultMap.put("lastDaysPv", pvMap);
        int pvTotal = this.orgPVDao.getOrgTotalPV(Long.valueOf(orgNumber));
        resultMap.put("pvTotal", pvTotal);
        return resultMap;
    }

    @Override
    public OrgTransformResponseDto getOrgTransform(int orgId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0]);
        long orgNumber = orgAccount.getNumber().longValue();
        Date startMonthDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)30));
        Date startWeekDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)0));
        int monthCall = this.messageDao.getPeroidOrgCall(Long.valueOf(orgNumber), startMonthDate, endDate);
        int weekCall = this.messageDao.getPeroidOrgCall(Long.valueOf(orgNumber), startWeekDate, endDate);
        int callTotal = this.messageDao.getOrgCallCount(Long.valueOf(orgNumber));
        int monthLeaveBill = this.messageDao.getPeroidOrgLeaveBill(Long.valueOf(orgNumber), startMonthDate, endDate);
        int weekLeaveBill = this.messageDao.getPeroidOrgLeaveBill(Long.valueOf(orgNumber), startWeekDate, endDate);
        int leaveBillTotal = this.messageDao.getOrgLeaveBillCount(Long.valueOf(orgNumber));
        int purchaseMonth = this.coursePurchaseDao.getOrgPuchaseByTime(Long.valueOf(orgId), startMonthDate, endDate);
        int purchaseWeek = this.coursePurchaseDao.getOrgPuchaseByTime(Long.valueOf(orgId), startWeekDate, endDate);
        int purchaseTotal = this.coursePurchaseDao.getTotalOrgPurchase(Long.valueOf(orgId));
        int messageMonth = this.imMessageInfoDao.getOrgMessageCount(Long.valueOf(orgNumber), startMonthDate, endDate);
        int messageWeek = this.imMessageInfoDao.getOrgMessageCount(Long.valueOf(orgNumber), startWeekDate, endDate);
        int messageTotal = this.imMessageInfoDao.getOrgMessageTotalCount(Long.valueOf(orgNumber));
        OrgTransformResponseDto orgTransformResponseDto = new OrgTransformResponseDto();
        orgTransformResponseDto.setLastWeekPurchase(purchaseWeek);
        orgTransformResponseDto.setLastMonthPurchase(purchaseMonth);
        orgTransformResponseDto.setPurchaseTotal(purchaseTotal);
        orgTransformResponseDto.setLastWeekReserverBill(weekLeaveBill);
        orgTransformResponseDto.setLastMonthReserverBill(monthLeaveBill);
        orgTransformResponseDto.setReserverBillTotal(leaveBillTotal);
        orgTransformResponseDto.setLastWeekPhone(weekCall);
        orgTransformResponseDto.setLastMonthPhone(monthCall);
        orgTransformResponseDto.setPhoneTotal(callTotal);
        orgTransformResponseDto.setLastWeekIm(messageWeek);
        orgTransformResponseDto.setLastMonthIm(messageMonth);
        orgTransformResponseDto.setImTotal(messageTotal);
        return orgTransformResponseDto;
    }

    @Override
    public synchronized void calculateCoursePv() {
        log.info("begin calculateCoursePv");
        int maxTeacherCourseId = this.teacherClassCourseDao.getMaxId();
        for (int i = 1; i <= maxTeacherCourseId; ++i) {
            TeacherClassCourse teacherCourse = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)Integer.valueOf(i), new String[0]);
            if (teacherCourse == null || teacherCourse.getOrganizationNumber() == null) continue;
            int pv = this.orgCourseAccessDao.getCourseTotalPv(teacherCourse.getNumber().longValue());
            int purchaseCount = this.coursePurchaseDao.getCourseTotalCount(teacherCourse.getNumber());
            int leaveBillCount = this.orgStudentAdvisoryDao.getTotalTeacherCourseAdvisory(Long.valueOf(i));
            int messageCount = this.callServiceStatisticsDao.getAllStatistics(teacherCourse.getNumber());
            int transform = purchaseCount + leaveBillCount + messageCount;
            teacherCourse.setPageView(Integer.valueOf(pv));
            teacherCourse.setTransform(Integer.valueOf(transform));
            this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"pageView", "transform"});
        }
        int maxOrgCourseId = this.orgCourseDao.getMaxId();
        for (int i = 1; i <= maxOrgCourseId; ++i) {
            OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)Integer.valueOf(i), new String[0]);
            if (orgCourse == null || orgCourse.getOrgNumber() == null) continue;
            int pv = this.orgCourseAccessDao.getCourseTotalPv(orgCourse.getNumber().longValue());
            int purchaseCount = this.coursePurchaseDao.getCourseTotalCount(orgCourse.getNumber());
            int leaveBillCount = this.orgStudentAdvisoryDao.getTotalOrgCourseAdvisory(Long.valueOf(i));
            int messageCount = this.callServiceStatisticsDao.getAllStatistics(orgCourse.getNumber());
            int transform = purchaseCount + leaveBillCount + messageCount;
            orgCourse.setPageView(Integer.valueOf(pv));
            orgCourse.setTransform(Integer.valueOf(transform));
            this.orgCourseDao.update((Object)orgCourse, new String[]{"pageView", "transform"});
        }
        int maxVideoCourse = this.videoCourseDao.getMaxId();
        for (int i = 1; i <= maxVideoCourse; ++i) {
            VideoCourse videoCourse = (VideoCourse)this.videoCourseDao.getById((Serializable)Integer.valueOf(i), new String[0]);
            if (videoCourse == null) continue;
            int pv = this.orgCourseAccessDao.getCourseTotalPv(videoCourse.getNumber().longValue());
            int purchaseCount = this.coursePurchaseDao.getCourseTotalCount(videoCourse.getNumber());
            int leaveBillCount = 0;
            int messageCount = this.callServiceStatisticsDao.getAllStatistics(videoCourse.getNumber());
            int transform = purchaseCount + leaveBillCount + messageCount;
            videoCourse.setPageView(Integer.valueOf(pv));
            videoCourse.setTransform(Integer.valueOf(transform));
            this.videoCourseDao.update((Object)videoCourse, new String[]{"pageView", "transform"});
        }
        log.info("end calculateCoursePv");
    }

    @Override
    public void calculateCourseCall() {
        log.info("begin calculateCourseCall");
        HashMap params = Maps.newHashMap();
        params.put("app_id", this.galaxyAppid);
        params.put("database", this.galaxyDatabase);
        String day = "";
        DateTime d = new DateTime(new Date().getTime());
        long ts = 0L;
        if (d.getHourOfDay() == 0 || d.getHourOfDay() == 1) {
            day = JodaDateUtil.getDayBegin((Long)new Date().getTime(), (int)1);
            ts = JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)1);
        } else {
            day = JodaDateUtil.getDayBegin((Long)new Date().getTime(), (int)0);
            ts = JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)0);
        }
        day = StringUtils.replace((String)day, (String)"-", (String)"");
        Date currentDate = new Date(ts);
        StringBuilder sb = new StringBuilder();
        sb.append("select request_path_key,count(request_path_key) total from click_ctr_real_log where location like '%consult%' and pt='");
        sb.append(day).append("' group by request_path_key");
        params.put("query", sb.toString());
        log.info("[calculateCourseCall]query string=" + sb.toString());
        String result = null;
        try {
            List<CallResponse> callList;
            result = HttpClientUtils.doJsonPost((String)this.galaxyQueryApi, (Map)params, (String)"UTF-8", (Integer)600000);
            log.info("result=" + result);
            GalaxyCallResponseDto galaxyCallResponseDto = (GalaxyCallResponseDto)((Object)JacksonUtil.str2Obj((String)result, GalaxyCallResponseDto.class));
            if (galaxyCallResponseDto.getCode() == 0 && CollectionUtils.isNotEmpty(callList = galaxyCallResponseDto.getRows())) {
                for (CallResponse callResponse : callList) {
                    Long courseNumber = callResponse.getRequest_path_key();
                    if (courseNumber == null) continue;
                    CallServiceStatistics callServiceStatistics = this.callServiceStatisticsDao.getStatistics(courseNumber, currentDate);
                    if (callServiceStatistics != null) {
                        callServiceStatistics.setTotalCount(callResponse.getTotal());
                        callServiceStatistics.setUpdateAt(new Date());
                        this.callServiceStatisticsDao.update((Object)callServiceStatistics, new String[0]);
                        continue;
                    }
                    CallServiceStatistics newStatistics = new CallServiceStatistics();
                    newStatistics.setCourseNumber(courseNumber);
                    newStatistics.setDay(currentDate);
                    newStatistics.setTotalCount(callResponse.getTotal());
                    newStatistics.setUpdateAt(new Date());
                    this.callServiceStatisticsDao.save((Object)newStatistics, Boolean.valueOf(true), new String[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("calculateCourseCall error", (Throwable)e);
            e.printStackTrace();
        }
        log.info("end calculateCourseCall");
    }

    @Override
    public void calculateRank() {
        log.info("begin calculateRank");
        HashMap params = Maps.newHashMap();
        params.put("app_id", this.galaxyAppid);
        params.put("database", this.galaxyDatabase);
        String startDayStr = JodaDateUtil.getDayBegin((Long)new Date().getTime(), (int)7).replaceAll("-", "");
        String endDayStr = JodaDateUtil.getDayBegin((Long)new Date().getTime(), (int)0).replaceAll("-", "");
        StringBuilder sb = new StringBuilder("");
        sb.append("select td.class_number classnumber ");
        sb.append(" from search_course_data td ");
        sb.append(" where td.pt>='").append(startDayStr).append("' ");
        sb.append(" and td.pt<='").append(endDayStr).append("' ");
        sb.append(" and td.class_number!='' ");
        sb.append(" group by td.class_number having (sum(td.rank)+sum(td.offset))<=10");
        params.put("query", sb.toString());
        HashSet<Long> topSet = new HashSet<Long>();
        Set<Object> topSearchSet = new HashSet();
        String result = null;
        try {
            result = HttpClientUtils.doJsonPost((String)this.galaxyQueryApi, (Map)params, (String)"UTF-8", (Integer)600000);
            GalaxyTopSearchResponseDto galaxyTopSearchResponseDto = (GalaxyTopSearchResponseDto)((Object)JacksonUtil.str2Obj((String)result, GalaxyTopSearchResponseDto.class));
            topSearchSet = galaxyTopSearchResponseDto.getRows();
            if (CollectionUtils.isNotEmpty(topSearchSet)) {
                for (TopSearch topSearch : topSearchSet) {
                    topSet.add(topSearch.getClassnumber());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info(result);
        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp((Long)new Date().getTime(), (int)0));
        int n = this.teacherClassCourseDao.getMaxId();
        for (int i = 1; i <= n; ++i) {
            TeacherClassCourse teacherCourse = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)Integer.valueOf(i), new String[0]);
            if (teacherCourse == null || teacherCourse.getOrganizationNumber() == null) continue;
            if (teacherCourse.getEndTime() != null && teacherCourse.getEndTime().getTime() < System.currentTimeMillis()) {
                teacherCourse.setExtendStatus(Integer.valueOf(0));
                this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"extendStatus"});
            }
            if (teacherCourse.getStatus() != null && teacherCourse.getVerifyStatus() != null && teacherCourse.getStatus() != 2 && teacherCourse.getVerifyStatus() != 2) {
                teacherCourse.setExtendStatus(Integer.valueOf(0));
                this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"extendStatus"});
            }
            Long courseNumber = teacherCourse.getNumber();
            Integer verifyStatus = teacherCourse.getVerifyStatus();
            List blobList = this.teacherClassCourseDao.getBlobString(teacherCourse.getOrganizationNumber(), courseNumber);
            String introduce = "";
            if (CollectionUtils.isNotEmpty((Collection)blobList)) {
                introduce = (String)blobList.get(0);
            }
            if (verifyStatus == 2) {
                teacherCourse.setRank(Integer.valueOf(1));
                teacherCourse.setExtendStatus(Integer.valueOf(0));
                this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"rank", "extendStatus"});
                continue;
            }
            if (introduce == null || !introduce.contains("<img")) {
                teacherCourse.setRank(Integer.valueOf(2));
                teacherCourse.setExtendStatus(Integer.valueOf(0));
                this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"rank", "extendStatus"});
                continue;
            }
            int coursePeroidPv = this.orgCourseAccessDao.getCoursePeroidPv(courseNumber.longValue(), startDate, endDate);
            boolean isContain = topSet.contains(courseNumber);
            if (coursePeroidPv >= 14) {
                if (isContain) {
                    teacherCourse.setRank(Integer.valueOf(5));
                    this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"rank"});
                    continue;
                }
                teacherCourse.setRank(Integer.valueOf(4));
                this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"rank"});
                continue;
            }
            teacherCourse.setRank(Integer.valueOf(3));
            this.teacherClassCourseDao.update((Object)teacherCourse, new String[]{"rank"});
        }
        int maxOrgCourseId = this.orgCourseDao.getMaxId();
        for (int i = 1; i <= maxOrgCourseId; ++i) {
            OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)Integer.valueOf(i), new String[0]);
            if (orgCourse == null || orgCourse.getOrgNumber() == null) continue;
            Integer status = orgCourse.getStatus();
            if (status != null && status != 0) {
                orgCourse.setExtendStatus(Integer.valueOf(0));
                this.orgCourseDao.update((Object)orgCourse, new String[]{"extendStatus"});
            }
            Long courseNumber = orgCourse.getNumber();
            int coursePeroidPv = this.orgCourseAccessDao.getCoursePeroidPv(courseNumber.longValue(), startDate, endDate);
            boolean isContainTop = topSet.contains(courseNumber);
            List blobList = this.orgCourseDao.getBlobString(orgCourse.getOrgNumber(), courseNumber);
            String introduce = "";
            if (CollectionUtils.isNotEmpty((Collection)blobList)) {
                introduce = (String)blobList.get(0);
            }
            boolean isHasPic = false;
            boolean isArrangeClass = false;
            if (StringUtils.isNotBlank((CharSequence)introduce) && introduce.contains("<img")) {
                isHasPic = true;
            }
            if (orgCourse.getBeginTime() != null || StringUtils.isNotBlank((CharSequence)orgCourse.getLessonSummary())) {
                isArrangeClass = true;
            }
            if (isArrangeClass) {
                if (isHasPic) {
                    if (coursePeroidPv >= 14) {
                        if (isContainTop) {
                            orgCourse.setRank(Integer.valueOf(5));
                            this.orgCourseDao.update((Object)orgCourse, new String[]{"rank"});
                            continue;
                        }
                        orgCourse.setRank(Integer.valueOf(4));
                        this.orgCourseDao.update((Object)orgCourse, new String[]{"rank"});
                        continue;
                    }
                    orgCourse.setRank(Integer.valueOf(3));
                    this.orgCourseDao.update((Object)orgCourse, new String[]{"rank"});
                    continue;
                }
                orgCourse.setRank(Integer.valueOf(2));
                orgCourse.setExtendStatus(Integer.valueOf(0));
                this.orgCourseDao.update((Object)orgCourse, new String[]{"rank", "extendStatus"});
                continue;
            }
            orgCourse.setRank(Integer.valueOf(2));
            orgCourse.setExtendStatus(Integer.valueOf(0));
            this.orgCourseDao.update((Object)orgCourse, new String[]{"rank", "extendStatus"});
        }
        log.info("end calculateRank");
    }

    @Override
    public void addClickRecord(int orgId, Long courseNumber, int type) {
        OrgClickLog orgClickLog = new OrgClickLog();
        orgClickLog.setOrgId(Integer.valueOf(orgId));
        orgClickLog.setType(Integer.valueOf(type));
        orgClickLog.setCourseNumber(courseNumber);
        orgClickLog.setCreateTime(new Date());
        this.orgClickLogDao.save((Object)orgClickLog, new String[0]);
    }

    @Override
    public boolean hasClickRecord(int orgId, Long courseNumber, int type) {
        OrgClickLog orgClickLog = this.orgClickLogDao.getOrgCourseClick(orgId, courseNumber.longValue(), type);
        return orgClickLog != null;
    }

    @Override
    public int getUserLevel(long orgNumber) {
        HashMap params = Maps.newHashMap();
        params.put("orgNumber", String.valueOf(orgNumber));
        String result = null;
        try {
            result = HttpClientUtils.doPost((String)this.userLevelUrl, (Map)params, (String)"UTF-8");
            UserLevelResponseDto userLevelResponseDto = (UserLevelResponseDto)((Object)JacksonUtil.str2Obj((String)result, UserLevelResponseDto.class));
            return userLevelResponseDto.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public CommonInfoResponse getCommonInfo(int orgId) {
        OrgAccount orgAccount;
        CommonInfoResponse commonInfoResponse = new CommonInfoResponse();
        commonInfoResponse.setId(orgId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId), new String[0]);
        if (orgInfo != null) {
            commonInfoResponse.setName(orgInfo.getName());
        }
        if ((orgAccount = this.orgAccountDao.getAccountById(orgId, new String[0])) != null) {
            commonInfoResponse.setLevel(this.getUserLevel(orgAccount.getNumber().intValue()));
        }
        return commonInfoResponse;
    }

    @Override
    public List<DiscoveryResponseDto> getDiscoveryInfo(boolean hasSmartPromote, String version) {
        ArrayList respList = Lists.newArrayList();
        ApplicationContext application = this.getApplicationContext();
        CourseAdvertiseServiceImpl tmp = (CourseAdvertiseServiceImpl)application.getBean("courseAdvertiseService");
        for (Discovery discovery : Discovery.values()) {
            if (version.compareTo(String.valueOf(discovery.getVersion())) < 0) continue;
            DiscoveryResponseDto discoveryResponseDto = new DiscoveryResponseDto();
            discoveryResponseDto.setGroup(discovery.getGroup());
            discoveryResponseDto.setEvent(discovery.getEvent());
            discoveryResponseDto.setVersion(discovery.getVersion());
            discoveryResponseDto.setTitle(discovery.getTitle());
            discoveryResponseDto.setIcon(discovery.getIcon());
            try {
                String refUrl = (String)FieldUtils.getField(CourseAdvertiseServiceImpl.class, (String)discovery.getUrl(), (boolean)true).get(tmp);
                discoveryResponseDto.setUrl(refUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            discoveryResponseDto.setAuth(discovery.getAuth());
            if (!StringUtils.isNotEmpty((CharSequence)this.displayItems) || !this.displayItems.contains(discovery.getEvent())) continue;
            if (discovery.getEvent().equals("tx_event_smartpromotion")) {
                if (!hasSmartPromote) continue;
                respList.add(discoveryResponseDto);
                continue;
            }
            respList.add(discoveryResponseDto);
        }
        return respList;
    }
}

