/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.teacher.api;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherInfoDto;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeachersDto;
import com.baijia.tianxiao.sal.teacher.dto.request.TeacherInfoRequest;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @author : zhenyujian
 * @title : OrgTeacherService
 * @description :
 * @date : 2016年3月25日 下午5:01:27
 */
public interface OrgTeacherService {

    /**
     *
     * @param orgId
     * @param request
     * @param szManagerId
     * @return
     */
    OrgTeacherInfoDto saveTeacher(Long orgId, TeacherInfoRequest request, Long szManagerId);

    /**
     * 直接写库
     * 
     * @param orgId
     * @param request
     * @param szManagerId
     * @return
     */
    OrgTeacherInfoDto saveTeacherOld(Long orgId, TeacherInfoRequest request, Long szManagerId);

    List<OrgTeacherInfoDto> list(Long orgId, Long lastId, Integer pageSize);

    public List<OrgTeacherInfoDto> listByOrgTeacherIds(Long orgId, List<Long> teacherIds);

    public Map<Long, OrgTeacherInfoDto> queryMapByOrgTeacherIds(Long orgId, List<Long> teacherIds);

    void del(Long teacherId);

    OrgTeacherInfoDto detail(Long teacherId);

    List<OrgTeachersDto> getAndUpdateOrgTeacherByOpenId(Long orgId, String weixinOpenId);

    OrgTeachersDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId)
        throws BussinessException;

    List<OrgTeacherInfoDto> listPage(Long orgId, PageDto pageDto);

    OrgTeacher getByUserId(long userId);

    int getTeacherIds(long l);

}