/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.teacher.impl;

import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.TeacherModifiedDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.TeacherModified;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherInfoDto;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeachersDto;
import com.baijia.tianxiao.sal.teacher.dto.request.TeacherInfoRequest;
import com.baijia.tianxiao.sal.teacher.util.OrgTeacherUtil;
import com.baijia.tianxiao.sal.teacher.util.TeacherErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.HtmlUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherServiceImpl
implements OrgTeacherService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherServiceImpl.class);
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private TeacherModifiedDao teacherModifiedDao;

    @Override
    public OrgTeacherInfoDto saveTeacher(Long orgId, TeacherInfoRequest request, Long szManagerId) {
        User user;
        List temp;
        Preconditions.checkArgument((request.getName() != null && request.getName().length() <= 15 ? 1 : 0) != 0, (Object)"\u59d3\u540d\u5fc5\u586b,\u800c\u4e14\u4e0d\u80fd\u5927\u4e8e15\u4e2a\u5b57");
        OrgTeacher orgTeacher = null;
        if (request.getId() == null) {
            temp = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), Integer.valueOf(1), new String[0]);
            if (temp != null && temp.size() > 0) {
                throw new BussinessException((UniverseErrorCode)TeacherErrorCode.MOBILE_DOUBLE);
            }
        } else {
            orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)request.getId(), new String[0]);
            if (!request.getMobile().equals(orgTeacher.getMobile()) && (temp = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), Integer.valueOf(1), new String[0])) != null && temp.size() > 0) {
                throw new BussinessException((UniverseErrorCode)TeacherErrorCode.MOBILE_DOUBLE);
            }
        }
        if (request.getId() == null) {
            orgTeacher = new OrgTeacher();
            orgTeacher.setType(Integer.valueOf(2));
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            if (orgAccount != null) {
                orgTeacher.setOrgNumber(orgAccount.getNumber());
            }
            orgTeacher.setOrgManagerId(szManagerId);
        }
        if (orgTeacher.getUserId() == null) {
            Map<String, Long> userInfoMap = OrgTeacherUtil.getUserIdAndNumber(orgId, request.getMobile(), request.getName());
            orgTeacher.setUserId(userInfoMap.get("id"));
        }
        Teacher teacher = this.teacherDao.getByUserId(orgTeacher.getUserId(), new String[0]);
        TeacherModified teacherModified = this.teacherModifiedDao.getByUserId(orgTeacher.getUserId(), new String[0]);
        this.saveOrUpdateOrgTeacher(orgTeacher, request, orgId);
        this.SaveOrUpdateCdbTeacher(teacher, request, orgId);
        this.SaveOrUpdateCdbTeacherModify(teacherModified, request, orgId);
        if (request.getId() == null && (user = (User)this.userDao.getById((Serializable)orgTeacher.getUserId(), new String[0])) != null) {
            this.orgTeacherDao.saveCdbOrgTeacher(orgTeacher.getUserId(), user.getNumber(), orgId);
        }
        return this.detail(orgTeacher.getId());
    }

    @Override
    public void del(Long teacherId) {
        OrgTeacher orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)teacherId, new String[0]);
        if (orgTeacher != null) {
            TeacherModified teacherModified;
            orgTeacher.setStatus(Integer.valueOf(OrgTeacherStatus.TERMINATED.getCode()));
            orgTeacher.setFireTime(new Date());
            log.debug("del teacher == {}", (Object)orgTeacher);
            this.orgTeacherDao.update((Object)orgTeacher, new String[0]);
            Teacher teacher = this.teacherDao.getByUserId(orgTeacher.getUserId(), new String[0]);
            if (teacher != null) {
                teacher.setOrgId(null);
                teacher.setUpdatedAt(new Date());
                this.teacherDao.update((Object)teacher, Boolean.valueOf(true), new String[]{"orgId"});
            }
            if ((teacherModified = this.teacherModifiedDao.getByUserId(orgTeacher.getUserId(), new String[0])) != null) {
                teacherModified.setOrgId(null);
                teacherModified.setUpdatedAt(new Date());
                this.teacherModifiedDao.update((Object)teacherModified, Boolean.valueOf(true), new String[]{"orgId"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
    }

    @Override
    public OrgTeacherInfoDto detail(Long teacherId) {
        OrgTeacher orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)teacherId, new String[0]);
        OrgTeacherInfoDto orgTeacherInfoDto = new OrgTeacherInfoDto();
        if (orgTeacher != null) {
            Storage storage;
            Teacher teacher = this.teacherDao.getByUserId(orgTeacher.getUserId(), new String[0]);
            orgTeacherInfoDto.setUserId(teacher.getUserId());
            orgTeacherInfoDto.setId(orgTeacher.getId());
            orgTeacherInfoDto.setName(teacher.getRealName());
            orgTeacherInfoDto.setAvatar(teacher.getAvatar());
            if (teacher.getAvatar() != null && (storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0])) != null) {
                String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                orgTeacherInfoDto.setAvatarUrl(avatarUrl);
            }
            if (teacher.getBirthday() != null) {
                orgTeacherInfoDto.setBirthday(teacher.getBirthday().getTime());
            }
            User user = (User)this.userDao.getById((Serializable)teacher.getUserId(), new String[0]);
            orgTeacherInfoDto.setNumber(user.getNumber());
            orgTeacherInfoDto.setDescr(teacher.getIntroduce() != null ? teacher.getIntroduce() : "");
            orgTeacherInfoDto.setMobile(orgTeacher.getMobile());
            orgTeacherInfoDto.setGender(teacher.getSex());
            orgTeacherInfoDto.setRemark(teacher.getOtherInfo() == null ? "" : HtmlUtils.delHTMLTag((String)teacher.getOtherInfo()));
        }
        return orgTeacherInfoDto;
    }

    @Override
    public List<OrgTeacherInfoDto> list(Long orgId, Long lastId, Integer pageSize) {
        List orgTeachers = this.orgTeacherDao.listByLastId(orgId, lastId, pageSize, Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), new String[0]);
        if (orgTeachers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public List<OrgTeacherInfoDto> listPage(Long orgId, PageDto pageDto) {
        List orgTeachers = this.orgTeacherDao.getTeachersByOrgId(orgId, pageDto, new String[0]);
        if (orgTeachers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public List<OrgTeachersDto> getAndUpdateOrgTeacherByOpenId(Long orgId, String weixinOpenId) {
        List teachers = this.orgTeacherDao.getTeacherByOpenIdAndOrgId(orgId, weixinOpenId, Integer.valueOf(1), new String[0]);
        ArrayList result = Lists.newArrayList();
        if (teachers != null && !teachers.isEmpty()) {
            OrgTeachersDto item = null;
            for (OrgTeacher teacher : teachers) {
                Teacher realTeacher = this.teacherDao.getByUserId(teacher.getUserId(), new String[0]);
                item = new OrgTeachersDto();
                BeanUtils.copyProperties((Object)teacher, (Object)item);
                item.setTeacherId(teacher.getUserId());
                item.setClassName(this.getClassName(orgId, teacher.getUserId()));
                item.setName(realTeacher.getNickName());
                result.add(item);
                if (weixinOpenId.equals(teacher.getWeixin())) continue;
                teacher.setWeixin(weixinOpenId);
                teacher.setUpdateTime(new Date());
                this.orgTeacherDao.update((Object)teacher, new String[]{"weixin", "updateTime"});
            }
        }
        return result;
    }

    @Override
    public OrgTeachersDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId) throws BussinessException {
        OrgTeachersDto result = null;
        List teachers = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, mobile, Integer.valueOf(1), new String[0]);
        if (teachers != null && !teachers.isEmpty()) {
            result = new OrgTeachersDto();
            BeanUtils.copyProperties(teachers.get(0), (Object)result);
            result.setTeacherId(((OrgTeacher)teachers.get(0)).getId());
            for (OrgTeacher teacher : teachers) {
                String weixin = teacher.getWeixin();
                if (weinOpenId.equals(weixin)) continue;
                teacher.setWeixin(weinOpenId);
                teacher.setUpdateTime(new Date());
                this.orgTeacherDao.update((Object)teacher, new String[]{"weixin", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u7ed1\u5b9a\u5931\u8d25\uff0c\u60a8\u6240\u586b\u5199\u7684\u624b\u673a\u53f7\u4e0d\u662f\u8001\u5e08\u624b\u673a\u53f7");
        }
        return result;
    }

    private String getClassName(Long orgId, Long teacherId) {
        OrgAccount orgAccount;
        List list;
        List courseIds = this.orgCourseTeacherDao.getOrgTeacherCourseIds(orgId, teacherId);
        String name = "";
        if (courseIds != null && !courseIds.isEmpty() && (list = this.orgCourseDao.getCourseList((Collection)courseIds, Long.valueOf(Long.parseLong((orgAccount = this.orgAccountDao.getAccountById(Integer.parseInt(orgId + ""), new String[0])).getNumber() + "")), null, new String[0])) != null && !list.isEmpty()) {
            name = ((OrgCourse)list.get(0)).getName();
        }
        return StringUtils.isNotBlank((CharSequence)name) ? name : "\u672a\u52a0\u73ed";
    }

    private void saveOrUpdateOrgTeacher(OrgTeacher teacher, TeacherInfoRequest request, Long orgId) {
        teacher.setMobile(request.getMobile());
        teacher.setOrgId(orgId);
        teacher.setId(request.getId());
        Date now = new Date();
        if (teacher.getId() == null) {
            teacher.setSignTime(now);
            teacher.setCreateTime(now);
            teacher.setInviteTime(now);
        }
        teacher.setUpdateTime(now);
        teacher.setStatus(Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        log.debug("save or update org teacher = {}", (Object)teacher);
        this.orgTeacherDao.saveOrUpdate((Object)teacher, new String[0]);
    }

    private void SaveOrUpdateCdbTeacher(Teacher teacher, TeacherInfoRequest request, Long orgId) {
        if (teacher == null) {
            teacher = new Teacher();
            teacher.setCreatedAt(new Date());
        }
        teacher.setRealName(request.getName());
        teacher.setSex(request.getGender());
        teacher.setAvatar(request.getAvatar());
        if (StringUtils.isNotEmpty((CharSequence)request.getRemark())) {
            if (request.getRemark().length() > 20) {
                teacher.setShortIntroduce(request.getRemark().substring(0, 20) + "...");
            } else {
                teacher.setShortIntroduce(request.getRemark());
            }
            teacher.setOtherInfo(request.getRemark());
        }
        teacher.setOrgId(orgId);
        if (request.getBirthday() != null) {
            teacher.setBirthday(new Date(request.getBirthday()));
        }
        teacher.setUpdatedAt(new Date());
        log.debug("save or update cdb teacher = {}", (Object)teacher);
        this.teacherDao.saveOrUpdate((Object)teacher, new String[0]);
    }

    private void SaveOrUpdateCdbTeacherModify(TeacherModified teacherModified, TeacherInfoRequest request, Long orgId) {
        if (teacherModified == null) {
            teacherModified = new TeacherModified();
            teacherModified.setCreatedAt(new Date());
        }
        teacherModified.setRealName(request.getName());
        teacherModified.setSex(request.getGender());
        teacherModified.setAvatar(request.getAvatar());
        if (StringUtils.isNotEmpty((CharSequence)request.getRemark())) {
            if (request.getRemark().length() > 20) {
                teacherModified.setShortIntroduce(request.getRemark().substring(0, 20) + "...");
            } else {
                teacherModified.setShortIntroduce(request.getRemark());
            }
            teacherModified.setOtherInfo(request.getRemark());
        }
        teacherModified.setOrgId(orgId);
        if (request.getBirthday() != null) {
            teacherModified.setBirthday(new Date(request.getBirthday()));
        }
        teacherModified.setUpdatedAt(new Date());
        log.debug("save or update cdb teacherModified = {}", (Object)teacherModified);
        this.teacherModifiedDao.saveOrUpdate((Object)teacherModified, new String[0]);
    }

    private List<OrgTeacherInfoDto> buildOrgTeacherInfo(Long orgId, List<OrgTeacher> list) {
        ArrayList result = Lists.newArrayList();
        Map orgTeacherMap = CollectorUtil.collectMap(list, (Function)new Function<OrgTeacher, Long>(){

            public Long apply(OrgTeacher teacher) {
                return teacher.getUserId();
            }
        });
        List teachers = this.teacherDao.getByUserIds(orgTeacherMap.keySet(), new String[0]);
        Map teacherMap = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher teacher) {
                return teacher.getUserId();
            }
        });
        Map userMap = this.userDao.getMapByIds(orgTeacherMap.keySet(), new String[0]);
        List teacherLessoId = this.orgClassLessonDao.queryFinishedLessonCountByTeacherIds(orgId, orgTeacherMap.keySet(), DateUtil.getFirstDate((Date)new Date()), DateUtil.getDayDiff((int)0));
        Map classHourMap = CollectorUtil.collectMap((Collection)teacherLessoId, (Function)new Function<ClassHour, Long>(){

            public Long apply(ClassHour classHour) {
                return classHour.getTeacherId();
            }
        });
        Map scoreMap = this.orgLessonCommentDao.getAveCommentByTeacherIds(orgTeacherMap.keySet(), new String[0]);
        Map recommendMap = this.orgCourseGroupRelateDao.isRecommendTeacher(orgTeacherMap.keySet());
        Map storageIds = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher teacher) {
                return teacher.getAvatar();
            }
        });
        List storages = this.storageDao.getByIds(storageIds.keySet(), new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Long>(){

            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        for (OrgTeacher orgTeacher : list) {
            Storage storage;
            OrgTeacherInfoDto dto = new OrgTeacherInfoDto();
            Teacher teacher = (Teacher)teacherMap.get(orgTeacher.getUserId());
            dto.setId(orgTeacher.getId());
            if (teacher != null) {
                dto.setName(teacher.getRealName());
            }
            dto.setClassNum(classHourMap.get(orgTeacher.getUserId()) == null ? 0 : ((ClassHour)classHourMap.get(orgTeacher.getUserId())).getLessonCount());
            Long commentScore = (Long)scoreMap.get(orgTeacher.getUserId());
            if (commentScore == null) {
                dto.setCommentNum(0.0);
            } else {
                dto.setCommentNum(ArithUtil.round((double)((double)commentScore.longValue() / 100.0), (int)1));
            }
            Integer count = (Integer)recommendMap.get(orgTeacher.getUserId());
            if (count == null || count == 0) {
                dto.setRecommended(false);
            } else {
                dto.setRecommended(true);
            }
            dto.setCreateDate(orgTeacher.getSignTime() == null ? new Date().getTime() : orgTeacher.getSignTime().getTime());
            if (teacher.getAvatar() != null && (storage = (Storage)storageMap.get(teacher.getAvatar())) != null) {
                String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                dto.setAvatarUrl(avatarUrl);
            }
            dto.setUserId(teacher.getUserId());
            User user = (User)userMap.get(teacher.getUserId());
            dto.setNumber(user == null ? 0L : user.getNumber());
            dto.setDescr(teacher.getShortIntroduce() == null ? "" : teacher.getShortIntroduce());
            dto.setOtherInfo(teacher.getOtherInfo() == null ? "" : HtmlUtils.delHTMLTag((String)teacher.getOtherInfo()));
            result.add(dto);
        }
        return result;
    }

    @Override
    public OrgTeacher getByUserId(long parseLong) {
        return this.orgTeacherDao.getTeachersByUserId(Long.valueOf(parseLong));
    }

    @Override
    public int getTeacherIds(long id) {
        List list = this.orgTeacherDao.getTeacherIds(Long.valueOf(id), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        return list.size();
    }
}

