/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.teacher.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacherCourse;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeachersDto;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherServiceImpl
implements OrgTeacherService {
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgTeacherCourseDao orgTeacherCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private UserDao userDao;

    @Override
    public List<OrgTeachersDto> getAndUpdateOrgTeacherByOpenId(Long orgId, String weixinOpenId) {
        List teachers = this.orgTeacherDao.getTeacherByOpenIdAndOrgId(orgId, weixinOpenId, new String[0]);
        ArrayList result = Lists.newArrayList();
        if (teachers != null && !teachers.isEmpty()) {
            OrgTeachersDto item = null;
            for (OrgTeacher teacher : teachers) {
                item = new OrgTeachersDto();
                BeanUtils.copyProperties((Object)teacher, (Object)item);
                item.setTeacherId(teacher.getId());
                item.setClassName(this.getClassName(orgId, teacher.getId()));
                result.add(item);
                if (weixinOpenId.equals(teacher.getWeixin())) continue;
                teacher.setWeixin(weixinOpenId);
                teacher.setUpdateTime(new Date());
                this.orgTeacherDao.update((Object)teacher, new String[]{"weixin", "updateTime"});
            }
        }
        return result;
    }

    @Override
    public OrgTeachersDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId) throws BussinessException {
        OrgTeachersDto result = null;
        List teachers = null;
        User user = this.userDao.getByMobile(mobile, new String[0]);
        if (user != null) {
            teachers = this.orgTeacherDao.getTeacherByUserIdAndOrgId(orgId, user.getId(), new String[0]);
        }
        if (teachers != null && !teachers.isEmpty()) {
            result = new OrgTeachersDto();
            BeanUtils.copyProperties(teachers.get(0), (Object)result);
            result.setTeacherId(((OrgTeacher)teachers.get(0)).getId());
            for (OrgTeacher teacher : teachers) {
                String weixin = teacher.getWeixin();
                if (weinOpenId.equals(weixin)) continue;
                teacher.setWeixin(weinOpenId);
                teacher.setUpdateTime(new Date());
                this.orgTeacherDao.update((Object)teacher, new String[]{"weixin", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u7ed1\u5b9a\u5931\u8d25\uff0c\u60a8\u6240\u586b\u5199\u7684\u624b\u673a\u53f7\u4e0d\u662f\u8001\u5e08\u624b\u673a\u53f7");
        }
        return result;
    }

    private String getClassName(Long orgId, Long teacherId) {
        Long courseId;
        OrgCourse course;
        List courses = this.orgTeacherCourseDao.getOrgCourseIds(orgId, teacherId, null);
        String name = "";
        if (courses != null && !courses.isEmpty() && (course = (OrgCourse)this.orgCourseDao.getById((Serializable)(courseId = ((OrgTeacherCourse)courses.get(0)).getCourseId()), new String[]{"name"})) != null) {
            name = course.getName();
        }
        return StringUtils.isNotBlank((CharSequence)name) ? name : "\u672a\u52a0\u73ed";
    }
}

