package com.baijia.tianxiao.sal.student.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.http.RestUtils;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class OrgStudentUtil {

    /**
     * 通过浅注册获取userId
     * 
     * @param name
     * @param
     * @return <"id",..>,<"number",..>
     * @throws Exception
     */
    public static Map<String, Long> getUserIdAndNumber(String name) {
        try {
            Map<String, Long> userInfoMap = new HashMap<String, Long>();
            RestfulResult<Map<String, Object>> createResult = RestUtils.createStudent(null, null, name, null);
            
            String id = null;
            Object number = null;
            if (0 == createResult.getCode()) {
                if (null != createResult.getData()) {
                    id = createResult.getData().get("user_id").toString();
                    number = createResult.getData().get("number");
                    if (StringUtils.isNotBlank(id) ) {
                        userInfoMap.put("id", Long.valueOf(id));
                        if(number != null){
                            userInfoMap.put("number", Long.valueOf(number.toString()));
                        }
                        return userInfoMap;
                    } else {
                        log.warn("create student failed-----userId = {},number = {}", id, number);
                        throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                    }
                } else {
                    log.error("create student failed-----createResult.getData = {}", createResult.getData());
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
            } else {
                log.warn("create student failed-----createResult.getCode() = {}", createResult.getCode());
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
            }
        } catch (Exception e) {
            log.warn("create student get error:{}", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
        }
    }
}
