package com.baijia.tianxiao.sal.student.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 10:26:19 PM
 * @desc :
 */
public enum CustomFieldType {

    TEXT(1, "文本"),
    SINGLE_CHOICE(2, "单选"),
    MULTI_CHOICE(3, "多选"),
    DAY_DATE(4, "日期"),
    DAY_TIME_DATE(5, "日期时间"),
    INTEGER(6, "整数"),
    FLOAT(7, "浮点数"),
    PICTURE(8, "图片"),
    POSITION(9, "地理位置"),
    TAGS(10, "标签");

    public Integer type;
    public String desc;

    private static Map<Integer, CustomFieldType> enumMap = new HashMap<>();

    static {
        for (CustomFieldType fieldType : CustomFieldType.values()) {
            enumMap.put(fieldType.type, fieldType);
        }
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private CustomFieldType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CustomFieldType getCustomFieldType(Integer fieldType) {
        return enumMap.get(fieldType);
    }
    
    public static List<Integer> getChoiceType(){
        List<Integer> choiceTypes = new ArrayList<>();
        choiceTypes.add(CustomFieldType.SINGLE_CHOICE.getType());
        choiceTypes.add(CustomFieldType.MULTI_CHOICE.getType());
        return choiceTypes;
    }

    @SuppressWarnings("unchecked")
    public static <V extends Object> V retValue(Object value) {
        return (V) value;
    }

}
